/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util.xmlsecurity;

import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.internal.util.xmlsecurity.DefaultXMLSecureFactories;

public class XMLSecureFactoriesPropertiesTestCase {
    private static final List<String> FACTORY_ATTRIBUTES = Arrays.asList("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "http://javax.xml.XMLConstants/property/accessExternalDTD");
    private static final List<String> VALIDATOR_PROPERTIES = Arrays.asList("http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalDTD");
    private static final List<String> SCHEMA_FACTORY_PROPERTIES = Arrays.asList("http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalDTD");
    private final DefaultXMLSecureFactories defaultXMLSecureFactories = new DefaultXMLSecureFactories(Boolean.valueOf(false), Boolean.valueOf(false));
    private final SchemaFactory schemaFactory = XMLSecureFactories.createDefault().getSchemaFactory("http://www.w3.org/2001/XMLSchema");
    private final TransformerFactory transformerFactory = XMLSecureFactories.createDefault().getTransformerFactory();
    private final Validator validatorWrapper = (Validator)Mockito.mock(Validator.class);
    private final SchemaFactory schemaFactoryWrapper = (SchemaFactory)Mockito.mock(SchemaFactory.class);
    private final TransformerFactory transformerFactoryWrapper = (TransformerFactory)Mockito.mock(TransformerFactory.class);

    @Test
    public void validatorProperties() throws Exception {
        SetPropertyAnswer setPropertyAnswer = new SetPropertyAnswer(this.schemaFactory.newSchema().newValidator());
        ((Validator)Mockito.doAnswer((Answer)setPropertyAnswer).when((Object)this.validatorWrapper)).setProperty(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        this.defaultXMLSecureFactories.configureValidator(this.validatorWrapper);
        MatcherAssert.assertThat((Object)setPropertyAnswer.exception, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        for (String property : VALIDATOR_PROPERTIES) {
            ((Validator)Mockito.verify((Object)this.validatorWrapper)).setProperty(property, "");
        }
    }

    @Test
    public void schemaFactoryProperties() throws Exception {
        SetPropertyAnswer setPropertyAnswer = new SetPropertyAnswer(this.schemaFactory);
        ((SchemaFactory)Mockito.doAnswer((Answer)setPropertyAnswer).when((Object)this.schemaFactoryWrapper)).setProperty(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        this.defaultXMLSecureFactories.configureSchemaFactory(this.schemaFactoryWrapper);
        MatcherAssert.assertThat((Object)setPropertyAnswer.exception, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        for (String property : SCHEMA_FACTORY_PROPERTIES) {
            ((SchemaFactory)Mockito.verify((Object)this.schemaFactoryWrapper)).setProperty(property, "");
        }
    }

    @Test
    public void transformerFactoryProperties() {
        SetPropertyAnswer setPropertyAnswer = new SetPropertyAnswer(this.transformerFactory);
        ((TransformerFactory)Mockito.doAnswer((Answer)setPropertyAnswer).when((Object)this.transformerFactoryWrapper)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        this.defaultXMLSecureFactories.configureTransformerFactory(this.transformerFactoryWrapper);
        MatcherAssert.assertThat((Object)setPropertyAnswer.exception, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        for (String property : FACTORY_ATTRIBUTES) {
            ((TransformerFactory)Mockito.verify((Object)this.transformerFactoryWrapper)).setAttribute(property, "");
        }
    }

    private class SetPropertyAnswer
    implements Answer<Void> {
        private final Object propertySetter;
        private Exception exception = null;

        SetPropertyAnswer(Object propertySetter) {
            this.propertySetter = propertySetter;
        }

        public Void answer(InvocationOnMock invocation) {
            block5: {
                String name = (String)invocation.getArguments()[0];
                Object value = invocation.getArguments()[1];
                try {
                    if (this.propertySetter instanceof SchemaFactory) {
                        ((SchemaFactory)this.propertySetter).setProperty(name, value);
                        break block5;
                    }
                    if (this.propertySetter instanceof Validator) {
                        ((Validator)this.propertySetter).setProperty(name, value);
                        break block5;
                    }
                    if (this.propertySetter instanceof TransformerFactory) {
                        ((TransformerFactory)this.propertySetter).setAttribute(name, value);
                        break block5;
                    }
                    throw new IllegalArgumentException("Invalid property setter.");
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
            return null;
        }
    }
}

