/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.internal.util.collection.ImmutableMapCollector;

public class ImmutableMapCollectorTestCase {
    private final ImmutableMapCollector<Fruit, String, Fruit> collector = new ImmutableMapCollector(f -> f.getClass().getName(), f -> f);

    @Test
    public void collect() {
        List<Fruit> fruits = Arrays.asList(new Apple(), new Banana(), new Kiwi());
        Map map = (Map)((Object)fruits.stream().collect(this.collector));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)3));
        fruits.forEach(fruit -> {
            Fruit value = (Fruit)map.get(fruit.getClass().getName());
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.sameInstance((Object)fruit));
        });
    }

    @Test
    public void emptyMap() {
        Map map = (Map)((Object)new ArrayList().stream().collect(this.collector));
        Assert.assertThat((Object)map.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private static class Fruit {
        private Fruit() {
        }
    }

    private static class Apple
    extends Fruit {
        private Apple() {
        }
    }

    private static class Banana
    extends Fruit {
        private Banana() {
        }
    }

    private static class Kiwi
    extends Fruit {
        private Kiwi() {
        }
    }
}

