/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.api.test.persistence.AbstractMuleArtifactModelJsonSerializerTestCase;

public class MulePolicyModelJsonSerializerTestCase
extends AbstractMuleArtifactModelJsonSerializerTestCase {
    private MulePolicyModelJsonSerializer mulePolicyModelJsonSerializer;

    @Before
    public void setUp() {
        this.mulePolicyModelJsonSerializer = new MulePolicyModelJsonSerializer();
    }

    @Test
    public void serializesModel() throws IOException {
        String describerName = "policy-name";
        String describerMinMuleVersion = "4.2.3";
        String describerClassLoaderModelId = "classLoaderModelLoaderID";
        HashMap<String, String> bundleDescriptorAttributes = new HashMap<String, String>();
        bundleDescriptorAttributes.put("bundleDescriptorLoaderKey1", "bundleDescriptorLoaderValue1");
        bundleDescriptorAttributes.put("bundleDescriptorLoaderKey2", "bundleDescriptorLoaderValue2");
        MulePolicyModel.MulePolicyModelBuilder mulePolicyModelBuilder = (MulePolicyModel.MulePolicyModelBuilder)((MulePolicyModel.MulePolicyModelBuilder)((MulePolicyModel.MulePolicyModelBuilder)new MulePolicyModel.MulePolicyModelBuilder().setName("policy-name")).setMinMuleVersion("4.2.3")).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("bundleDescriptorLoaderId", bundleDescriptorAttributes));
        mulePolicyModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("classLoaderModelLoaderID", Collections.emptyMap()));
        mulePolicyModelBuilder.setSupportedJavaVersions(Collections.singleton("17"));
        String actual = this.mulePolicyModelJsonSerializer.serialize((AbstractMuleArtifactModel)mulePolicyModelBuilder.build());
        JsonObject actualElement = new JsonParser().parse(actual).getAsJsonObject();
        MatcherAssert.assertThat((Object)actualElement.get("name").getAsString(), (Matcher)Is.is((Object)"policy-name"));
        MatcherAssert.assertThat((Object)actualElement.get("minMuleVersion").getAsString(), (Matcher)Is.is((Object)"4.2.3"));
        JsonObject classLoaderModelDescriptor = actualElement.get("classLoaderModelLoaderDescriptor").getAsJsonObject();
        MatcherAssert.assertThat((Object)classLoaderModelDescriptor.get("id").getAsString(), (Matcher)Is.is((Object)"classLoaderModelLoaderID"));
        MatcherAssert.assertThat((Object)classLoaderModelDescriptor.get("attributes").getAsJsonObject().entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
        JsonObject bundleDescriptor = actualElement.get("bundleDescriptorLoader").getAsJsonObject();
        MatcherAssert.assertThat((Object)bundleDescriptor.get("id").getAsString(), (Matcher)Is.is((Object)"bundleDescriptorLoaderId"));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().entrySet().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().get("bundleDescriptorLoaderKey1").getAsString(), (Matcher)Matchers.equalTo((Object)"bundleDescriptorLoaderValue1"));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().get("bundleDescriptorLoaderKey2").getAsString(), (Matcher)Matchers.equalTo((Object)"bundleDescriptorLoaderValue2"));
        JsonArray supportedJavaVersions = actualElement.getAsJsonArray("supportedJavaVersions");
        MatcherAssert.assertThat((Object)supportedJavaVersions.get(0).getAsString(), (Matcher)Matchers.equalTo((Object)"17"));
    }

    @Test
    public void deserializesModel() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/policy-descriptor-with-classloader-model.json");
        MulePolicyModel deserialized = (MulePolicyModel)this.mulePolicyModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        this.assertNameAndMinMuleVersion(deserialized);
        this.assertClassLoaderModel(deserialized);
        this.assertBundleDescriptorLoader(deserialized.getBundleDescriptorLoader());
    }

    @Test
    public void deserializesModelWithSupportedJavaVersions() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/policy-descriptor-with-supported-java-versions.json");
        MulePolicyModel deserialized = (MulePolicyModel)this.mulePolicyModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        MatcherAssert.assertThat((Object)deserialized.getSupportedJavaVersions(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"1.8", "11", "17"}));
    }

    private void assertNameAndMinMuleVersion(MulePolicyModel deserialize) {
        MatcherAssert.assertThat((Object)deserialize.getName(), (Matcher)Is.is((Object)"plugin-name"));
        MatcherAssert.assertThat((Object)deserialize.getMinMuleVersion(), (Matcher)Is.is((Object)"4.2.3"));
    }

    private void assertClassLoaderModel(MulePolicyModel deserialize) {
        MuleArtifactLoaderDescriptor extensionModelDescriptor = deserialize.getClassLoaderModelLoaderDescriptor();
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getId(), (Matcher)Is.is((Object)"maven"));
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getAttributes().size(), (Matcher)Is.is((Object)2));
        Object exportedPackages = extensionModelDescriptor.getAttributes().get("exportedPackages");
        MatcherAssert.assertThat(exportedPackages, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)((List)exportedPackages), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"org.mule.extension.api", "org.mule.extension.api.exception"}));
        Object exportedResources = extensionModelDescriptor.getAttributes().get("exportedResources");
        MatcherAssert.assertThat(exportedResources, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)((List)exportedResources), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"/META-INF/some.file", "/META-INF/other.file"}));
    }
}

