/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.internal.util.collection;

import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.internal.util.collection.UnmodifiableMap;

@Issue(value="MULE-19180")
public class UnmodifiableMapTestCase {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private Map<String, String> map;
    private Map<String, String> unmodifiable;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.map = Collections.singletonMap(KEY, VALUE);
        this.unmodifiable = UnmodifiableMap.unmodifiableMap(this.map);
    }

    @Test
    public void avoidMultiplesUnmodifiableMapInstances() {
        MatcherAssert.assertThat(this.unmodifiable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnmodifiableMap.class)));
        Map unmodifiable2 = UnmodifiableMap.unmodifiableMap(this.unmodifiable);
        MatcherAssert.assertThat((Object)unmodifiable2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnmodifiableMap.class)));
        MatcherAssert.assertThat(this.unmodifiable, (Matcher)Matchers.sameInstance((Object)unmodifiable2));
    }

    @Test
    public void testUnmodifiableMapSize() {
        MatcherAssert.assertThat((Object)this.unmodifiable.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testUnmodifiableMapIsEmpty() {
        Map unmodifiable = UnmodifiableMap.unmodifiableMap(Collections.emptyMap());
        MatcherAssert.assertThat((Object)unmodifiable.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        unmodifiable = UnmodifiableMap.unmodifiableMap(this.map);
        MatcherAssert.assertThat((Object)unmodifiable.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUnmodifiableMapContainsKey() {
        MatcherAssert.assertThat((Object)this.unmodifiable.containsKey(KEY), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.unmodifiable.containsKey("other-key"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUnmodifiableContainsValue() {
        MatcherAssert.assertThat((Object)this.unmodifiable.containsValue(VALUE), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.unmodifiable.containsValue("other-value"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUnmodifiableGet() {
        String value = this.unmodifiable.get(KEY);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)VALUE));
        value = this.unmodifiable.get("other-key");
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testUnmodifiablePut() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.put("other-key", "other-value");
    }

    @Test
    public void testUnmodifiableRemove() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.remove(KEY);
    }

    @Test
    public void testUnmodifiablePutAll() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.putAll(Collections.singletonMap("other-key", "other-value"));
    }

    @Test
    public void testUnmodifiableClear() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.clear();
    }

    @Test
    public void testUnmodifiableKeySet() {
        Set<String> keys = this.unmodifiable.keySet();
        MatcherAssert.assertThat((Object)keys.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])new String[]{KEY}));
    }

    @Test
    public void testUnmodifiableValues() {
        Collection<String> values = this.unmodifiable.values();
        MatcherAssert.assertThat((Object)values.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(values, (Matcher)Matchers.contains((Object[])new String[]{VALUE}));
    }

    @Test
    public void testUnmodifiableEntrySet() {
        Set<Map.Entry<String, String>> entries = this.unmodifiable.entrySet();
        MatcherAssert.assertThat((Object)entries.size(), (Matcher)CoreMatchers.is((Object)1));
        Map.Entry<String, String> entry = entries.iterator().next();
        MatcherAssert.assertThat((Object)entry.getKey(), (Matcher)CoreMatchers.is((Object)KEY));
        MatcherAssert.assertThat((Object)entry.getValue(), (Matcher)CoreMatchers.is((Object)VALUE));
    }

    @Test
    public void testUnmodifiableGetOrDefault() {
        String value = this.unmodifiable.getOrDefault(KEY, "defaultValue");
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)VALUE));
        value = this.unmodifiable.getOrDefault("other-key", "defaultValue");
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"defaultValue"));
    }

    @Test
    public void testUnmodifiableForEach() {
        HashSet keys = new HashSet();
        ArrayList values = new ArrayList();
        this.unmodifiable.forEach((k, v) -> {
            keys.add(k);
            values.add(v);
        });
        MatcherAssert.assertThat((Object)keys.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.contains((Object[])new String[]{KEY}));
        MatcherAssert.assertThat((Object)values.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(values, (Matcher)Matchers.contains((Object[])new String[]{VALUE}));
    }

    @Test
    public void testUnmodifiableReplaceAll() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.replaceAll((k, v) -> v + "-suffix");
    }

    @Test
    public void testUnmodifiablePutIfAbsent() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.putIfAbsent("other-key", "other-value");
    }

    @Test
    public void testUnmodifiableRemoveKeyValue() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.remove(KEY, VALUE);
    }

    @Test
    public void testUnmodifiableReplaceKeyValue() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.replace(KEY, VALUE, "other-value");
    }

    @Test
    public void testUnmodifiableReplace() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.replace(KEY, "other-value");
    }

    @Test
    public void testUnmodifiableComputeIfAbsent() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.computeIfAbsent("other-key", k -> k + "_value");
    }

    @Test
    public void testUnmodifiableComputeIfPresent() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.computeIfPresent(KEY, (k, v) -> k + "_" + v + "_value");
    }

    @Test
    public void testUnmodifiableCompute() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.compute(KEY, (k, v) -> k + "_" + v + "_value");
    }

    @Test
    public void testUnmodifiableMerge() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.unmodifiable.merge(KEY, "other-value", (old, newValue) -> old + "_" + newValue);
    }
}

