/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.parameterization;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;

public class ComponentParameterizationBuilder<M extends ParameterizedModel>
implements ComponentParameterization.Builder<M> {
    private static final LoadingCache<Reference<ParameterizedModel>, ComponentCache> CACHE = Caffeine.newBuilder().softValues().build(ref -> new ComponentCache((ParameterizedModel)ref.get()));
    private Reference<ParameterizedModel> model;
    private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters = new HashMap<Pair<ParameterGroupModel, ParameterModel>, Object>();
    private final Map<Pair<String, String>, Object> parametersByNames = new HashMap<Pair<String, String>, Object>();
    private Optional<ComponentIdentifier> identifier = Optional.empty();

    public ComponentParameterization.Builder<M> withModel(M model) {
        this.model = new Reference<M>(model);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String groupName, String paramName, Object value) throws IllegalArgumentException {
        this.parameters.put(((ComponentCache)CACHE.get(this.model)).getPair(groupName, paramName), value);
        this.parametersByNames.put(new Pair<String, String>(groupName, paramName), value);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(ParameterGroupModel groupModel, ParameterModel paramModel, Object value) {
        this.parameters.put(new Pair<ParameterGroupModel, ParameterModel>(groupModel, paramModel), value);
        this.parametersByNames.put(new Pair<String, String>(groupModel.getName(), paramModel.getName()), value);
        return this;
    }

    @Override
    public ComponentParameterization.Builder<M> withParameter(String paramName, Object value) throws IllegalArgumentException {
        Pair<ParameterGroupModel, ParameterModel> pair = ((ComponentCache)CACHE.get(this.model)).getPair(paramName);
        return this.withParameter(pair.getFirst(), pair.getSecond(), value);
    }

    @Override
    public ComponentParameterization.Builder<M> withComponentIdentifier(ComponentIdentifier identifier) {
        this.identifier = Optional.of(identifier);
        return this;
    }

    @Override
    public ComponentParameterization<M> build() {
        return new DefaultComponentParameterization<ParameterizedModel>(this.model.get(), Collections.unmodifiableMap(this.parameters), Collections.unmodifiableMap(this.parametersByNames), this.identifier);
    }

    private static class ComponentCache {
        private final ParameterizedModel model;
        private final LoadingCache<String, ParameterGroupModel> groups;
        private final LoadingCache<Pair<String, String>, Pair<ParameterGroupModel, ParameterModel>> params;
        private final LoadingCache<String, Pair<ParameterGroupModel, ParameterModel>> defaultParams;

        public ComponentCache(ParameterizedModel model) {
            this.model = model;
            this.groups = Caffeine.newBuilder().build(this::getGroupByName);
            this.params = Caffeine.newBuilder().build(this::toModelPair);
            this.defaultParams = Caffeine.newBuilder().build(this::findDefaultParamByName);
        }

        public Pair<ParameterGroupModel, ParameterModel> getPair(String groupName, String paramName) {
            return (Pair)this.params.get(new Pair<String, String>(groupName, paramName));
        }

        public Pair<ParameterGroupModel, ParameterModel> getPair(String paramName) {
            return (Pair)this.defaultParams.get((Object)paramName);
        }

        private ParameterGroupModel getGroupByName(String paramGroupName) {
            return this.model.getParameterGroupModels().stream().filter(pgm -> pgm.getName().equals(paramGroupName)).findAny().orElseThrow(() -> new IllegalArgumentException("ParameterGroup does not exist: " + paramGroupName));
        }

        private Pair<ParameterGroupModel, ParameterModel> findDefaultParamByName(String paramName) {
            ParameterGroupModel groupModel = null;
            ParameterModel parameterModel = null;
            for (ParameterGroupModel searchModel : this.model.getParameterGroupModels()) {
                Optional<ParameterModel> parameter = searchModel.getParameter(paramName);
                if (!parameter.isPresent()) continue;
                if (groupModel != null) {
                    throw new IllegalArgumentException("Parameter '" + paramName + "' exists in more than one group for component '" + this.model.getName() + "'");
                }
                groupModel = searchModel;
                if (parameterModel != null) continue;
                parameterModel = parameter.get();
            }
            if (parameterModel == null) {
                throw new IllegalArgumentException("Parameter does not exist in any group: " + paramName);
            }
            return new Pair<Object, Object>(groupModel, parameterModel);
        }

        private Pair<ParameterGroupModel, ParameterModel> toModelPair(Pair<String, String> pair) {
            ParameterGroupModel paramGroup = (ParameterGroupModel)this.groups.get((Object)pair.getFirst());
            String paramName = pair.getSecond();
            return paramGroup.getParameter(paramName).map(p -> new Pair<ParameterGroupModel, ParameterModel>(paramGroup, (ParameterModel)p)).orElseThrow(() -> new IllegalArgumentException("Parameter does not exist in group '" + paramGroup.getName() + "': " + paramName));
        }
    }

    private static class DefaultComponentParameterization<M extends ParameterizedModel>
    implements ComponentParameterization<M> {
        private final M model;
        private final Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters;
        private final Map<Pair<String, String>, Object> parametersByNames;
        private final Optional<ComponentIdentifier> identifier;

        public DefaultComponentParameterization(M model, Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters, Map<Pair<String, String>, Object> parametersByNames, Optional<ComponentIdentifier> identifier) {
            this.model = model;
            this.parameters = parameters;
            this.parametersByNames = parametersByNames;
            this.identifier = identifier;
        }

        @Override
        public M getModel() {
            return this.model;
        }

        @Override
        public Object getParameter(String paramGroupName, String paramName) {
            return this.parametersByNames.get(new Pair<String, String>(paramGroupName, paramName));
        }

        @Override
        public Object getParameter(ParameterGroupModel paramGroup, ParameterModel param) {
            return this.parameters.get(new Pair<ParameterGroupModel, ParameterModel>(paramGroup, param));
        }

        @Override
        public Map<Pair<ParameterGroupModel, ParameterModel>, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public void forEachParameter(ComponentParameterization.ParameterAction action) {
            this.parameters.entrySet().forEach(e -> action.accept((ParameterGroupModel)((Pair)e.getKey()).getFirst(), (ParameterModel)((Pair)e.getKey()).getSecond(), e.getValue()));
        }

        @Override
        public Optional<ComponentIdentifier> getComponentIdentifier() {
            return this.identifier;
        }
    }
}

