/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.bulk;

import java.io.Serializable;

public final class BulkItem<T>
implements Serializable {
    private static final long serialVersionUID = -2402370691833265593L;
    private final Serializable id;
    private final boolean successful;
    private final String message;
    private final String statusCode;
    private final Exception exception;
    private final T payload;

    private BulkItem(Serializable id, boolean successful, String message, String statusCode, Exception exception, T payload) {
        this.id = id;
        this.successful = successful;
        this.message = message;
        this.statusCode = statusCode;
        this.exception = exception;
        this.payload = payload;
    }

    public Serializable getId() {
        return this.id;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Exception getException() {
        return this.exception;
    }

    public T getPayload() {
        return this.payload;
    }

    public static <T> BulkItemBuilder<T> builder() {
        return new BulkItemBuilder();
    }

    public static class BulkItemBuilder<T> {
        private Serializable id;
        private boolean successful = true;
        private String message;
        private String statusCode;
        private Exception exception;
        private T payload;

        public BulkItemBuilder<T> setRecordId(Serializable recordId) {
            this.id = recordId;
            return this;
        }

        public BulkItemBuilder<T> setSuccessful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public BulkItemBuilder<T> setMessage(String message) {
            this.message = message;
            return this;
        }

        public BulkItemBuilder<T> setStatusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public BulkItemBuilder<T> setException(Exception exception) {
            this.exception = exception;
            this.successful = false;
            return this;
        }

        public BulkItemBuilder<T> setPayload(T payload) {
            this.payload = payload;
            return this;
        }

        protected BulkItem<T> build() {
            return new BulkItem(this.id, this.successful, this.message, this.statusCode, this.exception, this.payload);
        }
    }
}

