/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public final class ExpressionLanguageUtils {
    public static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    public static final String DEFAULT_EXPRESSION_POSTFIX = "]";

    private ExpressionLanguageUtils() {
    }

    public static String sanitize(String expression) {
        String sanitizedExpression;
        if (expression.startsWith(DEFAULT_EXPRESSION_PREFIX)) {
            if (!expression.endsWith(DEFAULT_EXPRESSION_POSTFIX)) {
                throw new ExpressionExecutionException(I18nMessageFactory.createStaticMessage(String.format("Unbalanced brackets in expression '%s'", expression)));
            }
            sanitizedExpression = expression.substring(DEFAULT_EXPRESSION_PREFIX.length(), expression.length() - DEFAULT_EXPRESSION_POSTFIX.length());
        } else {
            sanitizedExpression = expression;
        }
        return sanitizedExpression;
    }
}

