/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import org.mule.runtime.internal.util.ClassUtils;
import org.mule.runtime.internal.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static byte[] toByteArray(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName cannot be null");
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = FileUtils.newFile(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURI().toURL();
                } else {
                    logger.debug("Unable to load resource from the file system: " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource from the file system: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(() -> ClassUtils.getResource(resourceName, callingClass));
                if (url == null) {
                    logger.debug("Unable to load resource " + resourceName + " from the classpath");
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource " + resourceName + " from the classpath: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }
}

