/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.store;

import java.io.Serializable;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.AbstractObjectStoreSupport;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;

public abstract class TemplateObjectStore<T extends Serializable>
extends AbstractObjectStoreSupport<T> {
    @Override
    public boolean contains(String key) throws ObjectStoreException {
        this.validateKey(key);
        return this.doContains(key);
    }

    protected abstract boolean doContains(String var1) throws ObjectStoreException;

    @Override
    public void store(String key, T value) throws ObjectStoreException {
        this.validateKey(key);
        if (this.contains(key)) {
            throw new ObjectAlreadyExistsException(I18nMessageFactory.createStaticMessage("ObjectStore already contains entry for key " + key));
        }
        this.doStore(key, value);
    }

    protected abstract void doStore(String var1, T var2) throws ObjectStoreException;

    @Override
    public T retrieve(String key) throws ObjectStoreException {
        this.validatePresentKey(key);
        return this.doRetrieve(key);
    }

    protected abstract T doRetrieve(String var1) throws ObjectStoreException;

    @Override
    public T remove(String key) throws ObjectStoreException {
        this.validatePresentKey(key);
        T value = this.doRemove(key);
        if (value == null) {
            throw new ObjectDoesNotExistException(I18nMessageFactory.createStaticMessage("Object store does not contain a value for key " + key));
        }
        return value;
    }

    protected abstract T doRemove(String var1) throws ObjectStoreException;
}

