/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public final class ModuleNamespace {
    private String[] elements;

    public ModuleNamespace(String ... elements) {
        Preconditions.checkArgument(elements != null && elements.length > 0, "Invalid namespace, at least one namespace identifier is required");
        this.elements = this.normalize(elements);
    }

    public String[] getElements() {
        return this.elements;
    }

    public String toString() {
        return Arrays.stream(this.elements).reduce((identity, accumulator) -> identity + "::" + accumulator).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleNamespace that = (ModuleNamespace)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    private String[] normalize(String ... parts) {
        ArrayList<String> normalized = new ArrayList<String>(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{part})) continue;
            part = this.cleanUpPart(part);
            if (i + 1 < parts.length) {
                normalized.add(this.asPackagePart(part));
                continue;
            }
            normalized.add(this.asModulePart(part));
        }
        return normalized.toArray(new String[0]);
    }

    private String asModulePart(String part) {
        return Arrays.stream(part.split(" ")).filter(StringUtils::isNotBlank).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    private String asPackagePart(String part) {
        return StringUtils.removeAll((String)part, (String)" ").toLowerCase();
    }

    private String cleanUpPart(String part) {
        return part.replaceAll("[^\\w]", " ").replaceAll("[\\.\\-_\\ ]", " ");
    }
}

