/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.collection.SmallMap;

@NoInstantiate
public final class MuleExceptionInfo
implements Serializable {
    private static final long serialVersionUID = -6844204561753057827L;
    public static final String INFO_ERROR_TYPE_KEY = "Error type";
    public static final String INFO_CAUSED_BY_KEY = "Caused by";
    public static final String INFO_LOCATION_KEY = "Element";
    public static final String INFO_SOURCE_DSL_KEY = "Element DSL";
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    public static final String MISSING_DEFAULT_VALUE = "(None)";
    public static final String INFO_ERROR_TYPE_KEY_MSG = "Error type" + MuleExceptionInfo.getColonMatchingPad("Error type") + ": ";
    public static final String INFO_CAUSED_BY_KEY_MSG = "Caused by" + MuleExceptionInfo.getColonMatchingPad("Caused by") + ": ";
    public static final String INFO_LOCATION_KEY_MSG = "Element" + MuleExceptionInfo.getColonMatchingPad("Element") + ": ";
    public static final String INFO_SOURCE_DSL_KEY_MSG = "Element DSL" + MuleExceptionInfo.getColonMatchingPad("Element DSL") + ": ";
    public static final String FLOW_STACK_INFO_KEY_MSG = "FlowStack" + MuleExceptionInfo.getColonMatchingPad("FlowStack") + ": ";
    private boolean alreadyLogged = false;
    private ErrorType errorType;
    private List<MuleException> suppressedCauses = new ArrayList<MuleException>(4);
    private String location;
    private String dslSource;
    private Serializable flowStack;
    private final SmallMap<String, Object> additionalEntries = new SmallMap();

    void addToSummaryMessage(StringBuilder buf) {
        buf.append(INFO_LOCATION_KEY_MSG).append(this.location != null ? this.location : MISSING_DEFAULT_VALUE).append(System.lineSeparator()).append(INFO_SOURCE_DSL_KEY_MSG).append(this.dslSource != null ? this.dslSource : MISSING_DEFAULT_VALUE).append(System.lineSeparator()).append(INFO_ERROR_TYPE_KEY_MSG).append(this.errorType != null ? this.errorType.toString() : MISSING_DEFAULT_VALUE);
        if (!this.suppressedCauses.isEmpty()) {
            this.writeSuppressedCauses(buf);
        }
        buf.append(System.lineSeparator()).append(FLOW_STACK_INFO_KEY_MSG).append(this.flowStack != null ? this.flowStack : MISSING_DEFAULT_VALUE).append(System.lineSeparator());
    }

    private void writeSuppressedCauses(StringBuilder buffer) {
        String PADDING = MuleExceptionInfo.repeat(' ', INFO_CAUSED_BY_KEY_MSG.length());
        buffer.append(System.lineSeparator()).append(INFO_CAUSED_BY_KEY_MSG);
        Iterator<MuleException> causes = this.suppressedCauses.iterator();
        this.writeCause(buffer, causes.next());
        while (causes.hasNext()) {
            buffer.append(System.lineSeparator());
            buffer.append(PADDING);
            this.writeCause(buffer, causes.next());
        }
    }

    private void writeCause(StringBuilder buffer, MuleException causedByException) {
        ErrorType causedByErrorType = causedByException.getExceptionInfo().getErrorType();
        if (causedByErrorType != null) {
            buffer.append(causedByErrorType.toString()).append(": ");
        }
        buffer.append(causedByException.getMessage());
    }

    public boolean isAlreadyLogged() {
        return this.alreadyLogged;
    }

    public void setAlreadyLogged(boolean alreadyLogged) {
        this.alreadyLogged = alreadyLogged;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDslSource() {
        return this.dslSource;
    }

    public void setDslSource(String dslSource) {
        this.dslSource = dslSource;
    }

    public Serializable getFlowStack() {
        return this.flowStack;
    }

    public void setFlowStack(Serializable flowStack) {
        this.flowStack = flowStack;
    }

    public List<MuleException> getSuppressedCauses() {
        return this.suppressedCauses;
    }

    public void setSuppressedCauses(List<MuleException> suppressedCauses) {
        this.suppressedCauses = suppressedCauses;
    }

    public void addSuppressedCause(MuleException cause) {
        this.suppressedCauses.add(cause);
    }

    public void putAdditionalEntry(String name, Object info) {
        this.additionalEntries.put(name, info);
    }

    Map<String, Object> getAdditionalEntries() {
        SmallMap<String, Object> result = new SmallMap<String, Object>();
        result.putAll(this.additionalEntries);
        return result;
    }

    Map<String, Object> asMap() {
        SmallMap<String, Object> result = new SmallMap<String, Object>();
        result.putAll(this.additionalEntries);
        if (this.errorType != null) {
            result.put(INFO_ERROR_TYPE_KEY, this.errorType);
        }
        if (!this.suppressedCauses.isEmpty()) {
            result.put(INFO_CAUSED_BY_KEY, this.suppressedCauses);
        }
        if (this.location != null) {
            result.put(INFO_LOCATION_KEY, this.location);
        }
        if (this.dslSource != null) {
            result.put(INFO_SOURCE_DSL_KEY, this.dslSource);
        }
        if (this.flowStack != null) {
            result.put(FLOW_STACK_INFO_KEY, this.flowStack);
        }
        return result;
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    private static String getColonMatchingPad(String key) {
        int padSize = 22 - key.length();
        if (padSize > 0) {
            return MuleExceptionInfo.repeat(' ', padSize);
        }
        return "";
    }
}

