/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public class MuleServerPluginModel
extends AbstractMuleArtifactModel {
    private static final String PLUGIN_CLASS_NAME = "pluginClassName";
    private final MuleArtifactLoaderDescriptor extensionModelLoaderDescriptor;
    private final String pluginClassName;

    private MuleServerPluginModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor extensionModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptor, String pluginClassName) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptor);
        this.extensionModelLoaderDescriptor = extensionModelLoaderDescriptor;
        this.pluginClassName = pluginClassName;
    }

    public Optional<MuleArtifactLoaderDescriptor> getExtensionModelLoaderDescriptor() {
        return Optional.ofNullable(this.extensionModelLoaderDescriptor);
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    @Override
    protected void doValidateCustomFields(String descriptorName) {
        this.validateMandatoryFieldIsSet(descriptorName, this.pluginClassName, PLUGIN_CLASS_NAME);
    }

    public static class MuleServerPluginModelBuilder
    extends AbstractMuleArtifactModelBuilder<MuleServerPluginModelBuilder, MuleServerPluginModel> {
        private Optional<MuleArtifactLoaderDescriptorBuilder> extensionModelDescriptorBuilder = Optional.empty();
        private String pluginClassName;

        @Override
        protected MuleServerPluginModelBuilder getThis() {
            return this;
        }

        public MuleServerPluginModelBuilder withPluginClassName(String className) {
            this.pluginClassName = className;
            return this;
        }

        @Override
        public MuleServerPluginModel build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.pluginClassName), "pluginClassName cannot be blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return new MuleServerPluginModel(this.getName(), this.getMinMuleVersion(), this.getRequiredProduct(), this.getClassLoaderModelDescriptorLoader(), this.extensionModelDescriptorBuilder.isPresent() ? this.extensionModelDescriptorBuilder.get().build() : null, this.getBundleDescriptorLoader(), this.pluginClassName);
        }
    }
}

