/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.mule.runtime.api.util.collection.BiSmallMapDelegate;
import org.mule.runtime.api.util.collection.EmptySmallMapDelegate;
import org.mule.runtime.api.util.collection.PentaSmallMapDelegate;
import org.mule.runtime.api.util.collection.QuadSmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapDelegate;
import org.mule.runtime.api.util.collection.SmallMapEntry;
import org.mule.runtime.api.util.collection.TriSmallMapDelegate;
import org.mule.runtime.api.util.collection.UniSmallMapDelegate;
import org.mule.runtime.internal.util.collection.UnmodifiableMap;

public class SmallMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 702299469995340780L;
    private SmallMapDelegate<K, V> delegate;

    public static <K, V> SmallMap<K, V> of(K key, V value) {
        return new SmallMap<K, Object>(new UniSmallMapDelegate<K, Object>(new SmallMapEntry<K, V>(key, value), null));
    }

    public static <K, V> SmallMap<K, V> of(K k1, V v1, K k2, V v2) {
        return new SmallMap<K, Object>(new BiSmallMapDelegate<K, Object>(new SmallMapEntry<K, V>(k1, v1), new SmallMapEntry<K, V>(k2, v2), null));
    }

    public static <K, V> SmallMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new SmallMap<K, Object>(new TriSmallMapDelegate<K, Object>(new SmallMapEntry<K, V>(k1, v1), new SmallMapEntry<K, V>(k2, v2), new SmallMapEntry<K, V>(k3, v3), null));
    }

    public static <K, V> SmallMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new SmallMap<K, Object>(new QuadSmallMapDelegate<K, Object>(new SmallMapEntry<K, V>(k1, v1), new SmallMapEntry<K, V>(k2, v2), new SmallMapEntry<K, V>(k3, v3), new SmallMapEntry<K, V>(k4, v4), null));
    }

    public static <K, V> SmallMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new SmallMap<K, Object>(new PentaSmallMapDelegate<K, Object>(new SmallMapEntry<K, V>(k1, v1), new SmallMapEntry<K, V>(k2, v2), new SmallMapEntry<K, V>(k3, v3), new SmallMapEntry<K, V>(k4, v4), new SmallMapEntry<K, V>(k5, v5), null));
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return new SmallMap(new EmptySmallMapDelegate(null));
        }
        if (map instanceof SmallMap) {
            return ((SmallMap)map).copy();
        }
        switch (map.size()) {
            case 0: {
                return new SmallMap(new EmptySmallMapDelegate(null));
            }
            case 1: {
                return new SmallMap<K, Object>(new UniSmallMapDelegate<K, Object>(map.entrySet().iterator().next(), null));
            }
            case 2: {
                Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
                return new SmallMap<K, Object>(new BiSmallMapDelegate<K, Object>(it.next(), it.next(), null));
            }
            case 3: {
                Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
                return new SmallMap<K, Object>(new TriSmallMapDelegate<K, Object>(it.next(), it.next(), it.next(), null));
            }
            case 4: {
                Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
                return new SmallMap<K, Object>(new QuadSmallMapDelegate<K, Object>(it.next(), it.next(), it.next(), it.next(), null));
            }
            case 5: {
                Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
                return new SmallMap<K, Object>(new PentaSmallMapDelegate<K, Object>(it.next(), it.next(), it.next(), it.next(), it.next(), null));
            }
        }
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> forSize(int size) {
        return size < 5 ? new SmallMap<K, V>() : new HashMap(size);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        if (map instanceof UnmodifiableSmallMap) {
            return map;
        }
        if (map instanceof SmallMap) {
            return new UnmodifiableSmallMap((SmallMap)map);
        }
        return UnmodifiableMap.unmodifiableMap(map);
    }

    public SmallMap() {
        this.delegate = new EmptySmallMapDelegate(null);
    }

    private SmallMap(SmallMapDelegate<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V put(K key, V value) {
        this.delegate = this.delegate.fastPut(key, value);
        return this.delegate.getPreviousValue();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.delegate = this.delegate.fastPut(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.delegate = this.delegate.fastRemove(key);
        return this.delegate.getPreviousValue();
    }

    @Override
    public void clear() {
        this.delegate = new EmptySmallMapDelegate(null);
    }

    public SmallMap<K, V> copy() {
        return new SmallMap<K, V>(this.delegate.copy());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SmallMap) {
            return this.delegate.equals(((SmallMap)o).delegate);
        }
        if (o instanceof Map) {
            return Objects.equals(this.entrySet(), ((Map)o).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static class UnmodifiableSmallMap<K, V>
    extends SmallMap<K, V> {
        public UnmodifiableSmallMap(SmallMap<K, V> delegate) {
            super(((SmallMap)delegate).delegate);
        }

        @Override
        public V put(K key, V value) {
            throw this.unsupported();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw this.unsupported();
        }

        @Override
        public void clear() {
            throw this.unsupported();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw this.unsupported();
        }

        @Override
        public V remove(Object key) {
            throw this.unsupported();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw this.unsupported();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw this.unsupported();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw this.unsupported();
        }

        private UnsupportedOperationException unsupported() {
            throw new UnsupportedOperationException("Map is unmodifiable");
        }
    }
}

