/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleExceptionInfo;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MuleException
extends Exception {
    private static final long serialVersionUID = 4553533142751195715L;
    public static final String MULE_VERBOSE_EXCEPTIONS = "mule.verbose.exceptions";
    @Deprecated
    public static final String INFO_ALREADY_LOGGED_KEY = "Logged";
    public static final String INFO_ERROR_TYPE_KEY = "Error type";
    public static final String INFO_LOCATION_KEY = "Element";
    public static final String INFO_SOURCE_XML_KEY = "Element DSL";
    public static final String MISSING_DEFAULT_VALUE = "(None)";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleException.class);
    public static final String EXCEPTION_MESSAGE_DELIMITER = MuleException.repeat('*', 80) + System.lineSeparator();
    public static final String EXCEPTION_MESSAGE_SECTION_DELIMITER = MuleException.repeat('-', 80) + System.lineSeparator();
    public static boolean verboseExceptions = false;
    private final MuleExceptionInfo exceptionInfo = new MuleExceptionInfo();
    private String message = null;
    private I18nMessage i18nMessage;

    public static void refreshVerboseExceptions() {
        String p = System.getProperty(MULE_VERBOSE_EXCEPTIONS);
        verboseExceptions = p != null ? Boolean.parseBoolean(p) || LOGGER.isDebugEnabled() : LOGGER.isDebugEnabled();
    }

    public MuleException(I18nMessage message) {
        this(message, null);
    }

    public MuleException(I18nMessage message, Throwable cause) {
        super(null, ExceptionHelper.unwrap(cause), true, MuleException.isVerboseExceptions());
        this.setMessage(message);
    }

    public MuleException(Throwable cause) {
        this(cause != null ? I18nMessageFactory.createStaticMessage(cause.getMessage()) : null, cause);
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    private String getColonMatchingPad(String key) {
        int padSize = 22 - key.length();
        if (padSize > 0) {
            return MuleException.repeat(' ', padSize);
        }
        return "";
    }

    protected MuleException() {
        this((I18nMessage)null, (Throwable)null);
    }

    protected void setMessage(I18nMessage message) {
        this.message = message != null ? message.getMessage() : null;
        this.i18nMessage = message;
    }

    protected void setMessage(String message) {
        this.message = message;
        if (this.i18nMessage == null) {
            this.i18nMessage = I18nMessageFactory.createStaticMessage(message);
        }
    }

    public I18nMessage getI18nMessage() {
        return this.i18nMessage;
    }

    public int getMessageCode() {
        return this.i18nMessage == null ? 0 : this.i18nMessage.getCode();
    }

    public void addInfo(String name, Object info) {
        if (INFO_ERROR_TYPE_KEY.equals(name)) {
            this.exceptionInfo.setErrorType((ErrorType)info);
        } else if (INFO_LOCATION_KEY.equals(name)) {
            this.exceptionInfo.setLocation(Objects.toString(info));
        } else if (INFO_SOURCE_XML_KEY.equals(name)) {
            this.exceptionInfo.setDslSource(Objects.toString(info));
        } else if ("FlowStack".equals(name)) {
            this.exceptionInfo.setFlowStack((Serializable)info);
        } else {
            this.exceptionInfo.putAdditionalEntry(name, info);
        }
    }

    protected void appendMessage(String s) {
        this.message = this.message + s;
    }

    protected void prependMessage(String s) {
        this.message = this.message + ". " + s;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    public String getDetailedMessage() {
        if (MuleException.isVerboseExceptions()) {
            return this.getVerboseMessage();
        }
        return this.getSummaryMessage();
    }

    public String getVerboseMessage() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(System.lineSeparator()).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(System.lineSeparator());
        Map<String, Object> info = ExceptionHelper.getExceptionInfo(this);
        for (String key : info.keySet().stream().sorted().collect(Collectors.toList())) {
            buf.append(key);
            buf.append(this.getColonMatchingPad(key));
            buf.append(": ");
            buf.append(info.get(key) == null ? "null" : info.get(key).toString().replaceAll(System.lineSeparator(), System.lineSeparator() + MuleException.repeat(' ', 24))).append(System.lineSeparator());
        }
        buf.append(EXCEPTION_MESSAGE_SECTION_DELIMITER);
        buf.append("Root Exception stack trace:").append(System.lineSeparator());
        Throwable root = ExceptionHelper.getRootException(this);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        root.printStackTrace(p);
        buf.append(w.toString()).append(System.lineSeparator());
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    public String getSummaryMessage() {
        MuleException e = ExceptionHelper.getRootMuleException(this);
        if (!Objects.equals(e, this)) {
            return this.getMessage();
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(System.lineSeparator()).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(System.lineSeparator());
        this.exceptionInfo.addToSummaryMessage(buf);
        buf.append(System.lineSeparator()).append("  (set debug level logging or '-Dmule.verbose.exceptions=true' for everything)").append(System.lineSeparator());
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleException)) {
            return false;
        }
        MuleException exception = (MuleException)o;
        if (this.i18nMessage != null ? !this.i18nMessage.equals(exception.i18nMessage) : exception.i18nMessage != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(exception.message) : exception.message != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 29 * result + (this.i18nMessage != null ? this.i18nMessage.hashCode() : 0);
        return result;
    }

    public Map<String, Object> getInfo() {
        return this.exceptionInfo.asMap();
    }

    public MuleExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public static boolean isVerboseExceptions() {
        return verboseExceptions;
    }

    static {
        MuleException.refreshVerboseExceptions();
    }
}

