/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.Serializable;
import java.util.Map;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.collection.SmallMap;

@NoInstantiate
public final class MuleExceptionInfo
implements Serializable {
    private static final long serialVersionUID = -953920524424559726L;
    public static final String INFO_ERROR_TYPE_KEY = "Error type";
    public static final String INFO_LOCATION_KEY = "Element";
    public static final String INFO_SOURCE_DSL_KEY = "Element DSL";
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    public static final String MISSING_DEFAULT_VALUE = "(None)";
    public static final String INFO_ERROR_TYPE_KEY_MSG = "Error type" + MuleExceptionInfo.getColonMatchingPad("Error type") + ": ";
    public static final String INFO_LOCATION_KEY_MSG = "Element" + MuleExceptionInfo.getColonMatchingPad("Element") + ": ";
    public static final String INFO_SOURCE_DSL_KEY_MSG = "Element DSL" + MuleExceptionInfo.getColonMatchingPad("Element DSL") + ": ";
    public static final String FLOW_STACK_INFO_KEY_MSG = "FlowStack" + MuleExceptionInfo.getColonMatchingPad("FlowStack") + ": ";
    private boolean alreadyLogged = false;
    private ErrorType errorType;
    private String location;
    private String dslSource;
    private Serializable flowStack;
    private final SmallMap<String, Object> additionalEntries = new SmallMap();

    void addToSummaryMessage(StringBuilder buf) {
        buf.append(INFO_LOCATION_KEY_MSG).append(this.location != null ? this.location : MISSING_DEFAULT_VALUE).append(System.lineSeparator()).append(INFO_SOURCE_DSL_KEY_MSG).append(this.dslSource != null ? this.dslSource : MISSING_DEFAULT_VALUE).append(System.lineSeparator()).append(INFO_ERROR_TYPE_KEY_MSG).append(this.errorType != null ? this.errorType.toString() : MISSING_DEFAULT_VALUE).append(System.lineSeparator()).append(FLOW_STACK_INFO_KEY_MSG).append(this.flowStack != null ? this.flowStack : MISSING_DEFAULT_VALUE).append(System.lineSeparator());
    }

    public boolean isAlreadyLogged() {
        return this.alreadyLogged;
    }

    public void setAlreadyLogged(boolean alreadyLogged) {
        this.alreadyLogged = alreadyLogged;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDslSource() {
        return this.dslSource;
    }

    public void setDslSource(String dslSource) {
        this.dslSource = dslSource;
    }

    public Serializable getFlowStack() {
        return this.flowStack;
    }

    public void setFlowStack(Serializable flowStack) {
        this.flowStack = flowStack;
    }

    public void putAdditionalEntry(String name, Object info) {
        this.additionalEntries.put(name, info);
    }

    Map<String, Object> asMap() {
        SmallMap<String, Object> result = new SmallMap<String, Object>();
        result.putAll(this.additionalEntries);
        if (this.errorType != null) {
            result.put(INFO_ERROR_TYPE_KEY, this.errorType);
        }
        if (this.location != null) {
            result.put(INFO_LOCATION_KEY, this.location);
        }
        if (this.dslSource != null) {
            result.put(INFO_SOURCE_DSL_KEY, this.dslSource);
        }
        if (this.flowStack != null) {
            result.put(FLOW_STACK_INFO_KEY, this.flowStack);
        }
        return result;
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    private static String getColonMatchingPad(String key) {
        int padSize = 22 - key.length();
        if (padSize > 0) {
            return MuleExceptionInfo.repeat(' ', padSize);
        }
        return "";
    }
}

