/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.notification;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public final class MessageProcessorNotification
extends EnrichedServerNotification {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_PROCESSOR_PRE_INVOKE = 1601;
    public static final int MESSAGE_PROCESSOR_POST_INVOKE = 1602;
    private EventContext eventContext;

    public MessageProcessorNotification(EnrichedNotificationInfo notificationInfo, ComponentLocation componentLocation, EventContext eventContext, int action) {
        super(notificationInfo, action, componentLocation != null ? componentLocation.getRootContainerName() : null);
        this.eventContext = eventContext;
    }

    public static MessageProcessorNotification createFrom(Event event, ComponentLocation componentLocation, Component processor, Exception exceptionThrown, int action) {
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo(event, exceptionThrown, processor);
        return new MessageProcessorNotification(notificationInfo, componentLocation, event.getContext(), action);
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public String toString() {
        return this.getEventName() + "{action=" + MessageProcessorNotification.getActionName(this.action) + ", processor=" + this.getComponent().getLocation().getLocation() + ", resourceId=" + this.resourceIdentifier + ", serverId=" + this.serverId + ", timestamp=" + this.timestamp + "}";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public String getEventName() {
        return "MessageProcessorNotification";
    }

    static {
        MessageProcessorNotification.registerAction("message processor pre invoke", 1601);
        MessageProcessorNotification.registerAction("message processor post invoke", 1602);
    }
}

