/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.config;

import java.util.Optional;
import org.mule.runtime.api.config.Feature;

public enum MuleRuntimeFeature implements Feature
{
    HONOUR_RESERVED_PROPERTIES("Whether reserved properties such as 'app.name' can't be overridden by global properties.", "MULE-19038", "4.4.0, 4.3.1", "mule.honour.reserved.properties"),
    BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER("If set to true, then fixed batch aggregator will only commit when a full block is processed.", "EE-7443", "4.4.0, 4.3.1, 4.2.3", "mule.batch.fixed.aggregator.transaction.record.buffer"),
    COMPUTE_CONNECTION_ERRORS_IN_STATS(" If set to true, the connection errors will be computed to trigger alerts.", "MULE-19020", "4.4.0, 4.3.1", "mule.compute.connection.errors.in.stats"),
    ENABLE_POLICY_ISOLATION("If set to true, extensions imported by a policy will be managed in complete isolation from the extensions imported by the application that is being applied to, and validations will prevent the usage of explicit configurations declared by the application as part of the policy initialization.", "MULE-19226", "4.4.0, 4.3.1", "mule.enable.policy.isolation");

    private final String description;
    private final String issueId;
    private final String since;
    private final String overridingSystemPropertyName;

    private MuleRuntimeFeature(String description, String issue, String since) {
        this(description, issue, since, null);
    }

    private MuleRuntimeFeature(String description, String issueId, String since, String overridingSystemPropertyName) {
        this.description = description;
        this.issueId = issueId;
        this.since = since;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }
}

