/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.InputEvent;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultInputEvent
implements InputEvent {
    private Message message = Message.builder().nullValue().build();
    private Map<String, TypedValue<?>> variables = new HashMap();
    private Map<String, TypedValue<?>> parameters = new HashMap();
    private Map<String, TypedValue<?>> properties = new HashMap();
    private Error error;

    public DefaultInputEvent() {
    }

    public DefaultInputEvent(Event event) {
        this.message = event.getMessage();
        this.variables.putAll(event.getVariables());
        this.parameters.putAll(event.getParameters());
        this.properties.putAll(event.getProperties());
        this.error = event.getError().orElse(null);
    }

    public DefaultInputEvent(InputEvent inputEvent) {
        this.message = inputEvent.getMessage();
        this.variables.putAll(inputEvent.getVariables());
        this.parameters.putAll(inputEvent.getParameters());
        this.properties.putAll(inputEvent.getProperties());
        this.error = inputEvent.getError().orElse(null);
    }

    @Override
    public InputEvent message(Message message) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.message = message;
        return inputEvent;
    }

    @Override
    public InputEvent variables(Map<String, ?> variables) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.variables.clear();
        variables.forEach((key, value) -> this.variables.put((String)key, this.valueAsTypedValue(value)));
        return inputEvent;
    }

    private TypedValue<?> valueAsTypedValue(Object value) {
        return value instanceof TypedValue ? (TypedValue<Object>)value : TypedValue.of(value);
    }

    @Override
    public InputEvent addVariable(String key, Object value) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.variables.put(key, this.valueAsTypedValue(value));
        return inputEvent;
    }

    @Override
    public InputEvent addVariable(String key, Object value, DataType dataType) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.variables.put(key, this.valueAsTypedValue(value));
        return inputEvent;
    }

    @Override
    public InputEvent properties(Map<String, Object> properties) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.properties.clear();
        properties.forEach((key, value) -> this.properties.put((String)key, this.valueAsTypedValue(value)));
        return inputEvent;
    }

    @Override
    public InputEvent parameters(Map<String, Object> parameters) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.parameters.clear();
        parameters.forEach((key, value) -> this.parameters.put((String)key, this.valueAsTypedValue(value)));
        return inputEvent;
    }

    @Override
    public InputEvent addParameter(String key, Object value) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.parameters.put(key, this.valueAsTypedValue(value));
        return inputEvent;
    }

    @Override
    public InputEvent addParameter(String key, Object value, DataType dataType) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.parameters.put(key, new TypedValue<Object>(value, dataType));
        return inputEvent;
    }

    @Override
    public InputEvent error(Error error) {
        DefaultInputEvent inputEvent = new DefaultInputEvent(this);
        inputEvent.error = error;
        return inputEvent;
    }

    @Override
    public Map<String, TypedValue<?>> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public Map<String, TypedValue<?>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public Map<String, TypedValue<?>> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public Optional<Error> getError() {
        return Optional.ofNullable(this.error);
    }
}

