/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;

public class DataSize {
    private final int size;
    private final DataUnit unit;

    public DataSize(int size, DataUnit unit) {
        Preconditions.checkArgument(unit != null, "unit cannot be null");
        this.size = size;
        this.unit = unit;
    }

    public int toBytes() {
        return this.unit.toBytes(this.size);
    }

    public int toKB() {
        return this.unit.toKB(this.size);
    }

    public int toMB() {
        return this.unit.toMB(this.size);
    }

    public int toGB() {
        return this.unit.toGB(this.size);
    }

    public int getSize() {
        return this.size;
    }

    public DataUnit getUnit() {
        return this.unit;
    }
}

