/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.lifecycle;

import org.mule.runtime.api.exception.LocatedMuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.NamedObject;

public class LifecycleException
extends LocatedMuleException {
    private static final long serialVersionUID = 2909614055858287394L;
    private transient Object component;

    public LifecycleException(I18nMessage message, Object component) {
        super(message, component);
        this.component = component;
    }

    public LifecycleException(I18nMessage message, Throwable cause, Object component) {
        super(message, cause, component);
        this.component = component;
    }

    public LifecycleException(Throwable cause, Object component) {
        super(I18nMessageFactory.createStaticMessage(cause.getMessage()), cause, component);
        this.component = component;
    }

    public Object getComponent() {
        return this.component;
    }

    @Override
    protected String resolveProcessorPath(Object component) {
        if (component instanceof AnnotatedObject) {
            return super.resolveProcessorPath(component);
        }
        return String.format("%s @ %s", component == null ? "null" : (component instanceof NamedObject ? ((NamedObject)component).getName() : component.toString()), "app");
    }
}

