/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.jpms.api;

import java.lang.management.ManagementFactory;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JpmsUtils {
    private static final int JAVA_MAJOR_VERSION = Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
    private static final String CLASSLOADER_CONTAINER_JPMS_MODULE_LAYER = "mule.classloader.container.jpmsModuleLayer";
    public static final String MULE_SKIP_MODULE_TWEAKING_VALIDATION = "mule.module.tweaking.validation.skip";
    private static final Set<String> SERVICE_MODULE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("org.mule.service.", "com.mulesoft.mule.service.", "com.mulesoft.anypoint.gw.service."));
    private static final Set<String> REQUIRED_ADD_MODULES = new HashSet<String>(Arrays.asList("java.se", "org.mule.boot.tanuki", "org.mule.runtime.jpms.utils", "com.fasterxml.jackson.core", "org.apache.commons.codec"));
    private static final String REQUIRED_ADD_OPENS_JAVA_LANG = "--add-opens=java.base/java.lang=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_JAVA_LANG_REFLECT = "--add-opens=java.base/java.lang.reflect=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_JDK_INTERNAL_REF = "--add-opens=java.base/jdk.internal.ref=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_JAVA_NIO = "--add-opens=java.base/java.nio=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_SUN_NIO_CH = "--add-opens=java.base/sun.nio.ch=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_SUN_MANAGEMENT = "--add-opens=java.management/sun.management=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_COM_IBM_LANG_MANAGEMENT_INTERNAL = "--add-opens=jdk.management/com.ibm.lang.management.internal=org.mule.runtime.jpms.utils";
    private static final String REQUIRED_ADD_OPENS_COM_SUN_MANAGEMENT_INTERNAL = "--add-opens=jdk.management/com.sun.management.internal=org.mule.runtime.jpms.utils";
    private static final List<String> REQUIRED_ADD_OPENS = Arrays.asList("--add-opens=java.base/java.lang=org.mule.runtime.jpms.utils", "--add-opens=java.base/java.lang.reflect=org.mule.runtime.jpms.utils", "--add-opens=java.base/jdk.internal.ref=org.mule.runtime.jpms.utils", "--add-opens=java.base/java.nio=org.mule.runtime.jpms.utils", "--add-opens=java.base/sun.nio.ch=org.mule.runtime.jpms.utils", "--add-opens=java.management/sun.management=org.mule.runtime.jpms.utils", "--add-opens=jdk.management/com.ibm.lang.management.internal=org.mule.runtime.jpms.utils", "--add-opens=jdk.management/com.sun.management.internal=org.mule.runtime.jpms.utils");

    private JpmsUtils() {
    }

    public static void validateNoBootModuleLayerTweaking() {
        if (Boolean.getBoolean(MULE_SKIP_MODULE_TWEAKING_VALIDATION)) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("!! WARNING!");
            System.err.println("!! 'mule.module.tweaking.validation.skip' property MUST ONLY be used temporarily in development environments.");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        JpmsUtils.doValidateArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    static void doValidateArguments(List<String> arguments) {
        List illegalAddModules = arguments.stream().filter(arg -> arg.startsWith("--add-modules=")).flatMap(addModules -> Stream.of(addModules.split("=")[1].split(","))).filter(moduleName -> REQUIRED_ADD_MODULES.stream().noneMatch(moduleName::equals)).collect(Collectors.toList());
        if (!illegalAddModules.isEmpty()) {
            throw new IllegalArgumentException("Invalid module tweaking options passed to the JVM running the Mule Runtime: --add-modules=" + illegalAddModules);
        }
        List illegalArguments = arguments.stream().filter(arg -> arg.startsWith("--add-exports=") || arg.startsWith("--add-opens=") || arg.startsWith("--add-reads=") || arg.startsWith("--patch-module=")).filter(Predicate.not(REQUIRED_ADD_OPENS::contains)).collect(Collectors.toList());
        if (!illegalArguments.isEmpty()) {
            throw new IllegalArgumentException("Invalid module tweaking options passed to the JVM running the Mule Runtime: " + illegalArguments);
        }
    }

    public static void exploreJdkModules(Set<String> packages) {
        ModuleLayer.boot().modules().stream().filter(module -> {
            String moduleName = module.getName();
            return moduleName.startsWith("java.") || moduleName.startsWith("jdk.");
        }).forEach(module -> packages.addAll(module.getPackages()));
    }

    public static ClassLoader createModuleLayerClassLoader(URL[] modulePathEntries, ClassLoader parent) {
        if (!JpmsUtils.useModuleLayer()) {
            return new URLClassLoader(modulePathEntries, parent);
        }
        ModuleLayer layer = JpmsUtils.createModuleLayer(modulePathEntries, parent, Optional.empty(), false, true);
        return layer.findLoader(layer.modules().iterator().next().getName());
    }

    public static ClassLoader createModuleLayerClassLoader(URL[] modulePathEntriesParent, URL[] modulePathEntriesChild, MultiLevelClassLoaderFactory childClassLoaderFactory, ClassLoader parent) {
        return JpmsUtils.createModuleLayerClassLoader(modulePathEntriesParent, modulePathEntriesChild, childClassLoaderFactory, parent, Optional.empty());
    }

    public static ClassLoader createModuleLayerClassLoader(URL[] modulePathEntriesParent, URL[] modulePathEntriesChild, MultiLevelClassLoaderFactory childClassLoaderFactory, ClassLoader parentClassLoader, Optional<Class> clazz) {
        if (!JpmsUtils.useModuleLayer()) {
            return childClassLoaderFactory.create(parentClassLoader, modulePathEntriesParent, modulePathEntriesChild);
        }
        ModuleLayer resolvedParentLayer = clazz.map(cl -> cl.getModule().getLayer()).orElse(null);
        ModuleLayer parentLayer = JpmsUtils.createModuleLayer(modulePathEntriesParent, parentClassLoader, Optional.ofNullable(resolvedParentLayer), false, true);
        ClassLoader childParentClassLoader = parentLayer.findLoader(parentLayer.modules().iterator().next().getName());
        ModuleLayer childLayer = JpmsUtils.createModuleLayer(modulePathEntriesChild, childParentClassLoader, Optional.of(parentLayer), false, true);
        JpmsUtils.openToModule(childLayer, "org.mule.runtime.launcher", "org.mule.boot.api", Arrays.asList("org.mule.runtime.module.boot.internal"));
        JpmsUtils.openToModule(childLayer, "kryo.shaded", "java.base", Arrays.asList("java.lang", "java.lang.reflect"));
        JpmsUtils.openToModule(childLayer, "org.mule.runtime.jpms.utils", "java.base", Arrays.asList("java.lang", "java.lang.reflect"));
        try {
            JpmsUtils.openToModule(childLayer, "com.hazelcast.core", "java.base", Arrays.asList("java.lang", "jdk.internal.ref", "java.nio", "sun.nio.ch"));
            JpmsUtils.openToModule(childLayer, "com.hazelcast.core", "jdk.management", Arrays.asList("com.sun.management.internal", "com.ibm.lang.management.internal"));
            JpmsUtils.openToModule(childLayer, "com.hazelcast.core", "java.management", Collections.singletonList("sun.management"));
        }
        catch (IllegalCallerException illegalCallerException) {
            // empty catch block
        }
        return childLayer.findLoader(childLayer.modules().iterator().next().getName());
    }

    private static boolean useModuleLayer() {
        return Boolean.parseBoolean(System.getProperty(CLASSLOADER_CONTAINER_JPMS_MODULE_LAYER, "" + (JAVA_MAJOR_VERSION >= 17)));
    }

    public static ModuleLayer createModuleLayer(URL[] modulePathEntries, ClassLoader parent, Optional<ModuleLayer> parentLayer, boolean isolateDependenciesInTheirOwnLayer, boolean filterParentModules) {
        ModuleLayer.Controller controller;
        Set modulesToFilter;
        if (filterParentModules) {
            ModuleLayer layer = isolateDependenciesInTheirOwnLayer ? ModuleLayer.boot() : parentLayer.orElse(ModuleLayer.boot());
            modulesToFilter = JpmsUtils.getParentLayersModules(layer).stream().map(m -> m.getName()).collect(Collectors.toSet());
        } else {
            modulesToFilter = Collections.emptySet();
        }
        Path[] paths = (Path[])Stream.of(modulePathEntries).map(url -> {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Path[]::new);
        ModuleFinder modulesFinder = ModuleFinder.of(paths);
        Map<Boolean, List<ModuleReference>> modulesByIsolation = modulesFinder.findAll().stream().filter(moduleRef -> !modulesToFilter.contains(moduleRef.descriptor().name())).collect(Collectors.partitioningBy(moduleRef -> JpmsUtils.isolateInOrphanLayer(moduleRef, parentLayer)));
        ModuleLayer resolvedParentLayer = parentLayer.orElse(ModuleLayer.boot());
        if (isolateDependenciesInTheirOwnLayer) {
            Path[] isolatedModulesPaths = (Path[])modulesByIsolation.get(true).stream().map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder isolatedModulesFinder = ModuleFinder.of(isolatedModulesPaths);
            List<String> isolatedRoots = modulesByIsolation.get(true).stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList());
            Configuration isolatedModulesConfiguration = ModuleLayer.boot().configuration().resolve(isolatedModulesFinder, ModuleFinder.ofSystem(), isolatedRoots);
            ModuleLayer.Controller isolatedModulesController = ModuleLayer.defineModulesWithOneLoader(isolatedModulesConfiguration, Collections.singletonList(ModuleLayer.boot()), parent);
            Path[] notIsolatedModulesPaths = (Path[])modulesByIsolation.get(false).stream().map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder notIsolatedModulesFinder = ModuleFinder.of(notIsolatedModulesPaths);
            List<String> notIsolatedRoots = modulesByIsolation.get(false).stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList());
            Configuration configuration = Configuration.resolve(notIsolatedModulesFinder, Arrays.asList(isolatedModulesController.layer().configuration(), resolvedParentLayer.configuration()), ModuleFinder.ofSystem(), notIsolatedRoots);
            controller = ModuleLayer.defineModulesWithOneLoader(configuration, Arrays.asList(isolatedModulesController.layer(), resolvedParentLayer), parent);
        } else {
            Path[] filteredModulesPaths = (Path[])modulesByIsolation.values().stream().flatMap(Collection::stream).map(ModuleReference::location).filter(Optional::isPresent).map(Optional::get).map(uri -> Paths.get(uri)).toArray(Path[]::new);
            ModuleFinder filteredModulesFinder = ModuleFinder.of(filteredModulesPaths);
            List<String> roots = modulesByIsolation.values().stream().flatMap(Collection::stream).map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList());
            Configuration configuration = resolvedParentLayer.configuration().resolve(filteredModulesFinder, ModuleFinder.ofSystem(), roots);
            controller = ModuleLayer.defineModulesWithOneLoader(configuration, Collections.singletonList(resolvedParentLayer), parent);
        }
        return controller.layer();
    }

    private static Set<Module> getParentLayersModules(ModuleLayer moduleLayer) {
        HashSet<Module> modules = new HashSet<Module>(moduleLayer.modules());
        for (ModuleLayer parent : moduleLayer.parents()) {
            modules.addAll(JpmsUtils.getParentLayersModules(parent));
        }
        return modules;
    }

    private static boolean isolateInOrphanLayer(ModuleReference moduleRef, Optional<ModuleLayer> containerLayer) {
        if (moduleRef.descriptor().isAutomatic()) {
            if (SERVICE_MODULE_NAME_PREFIXES.stream().noneMatch(moduleRef.descriptor().name()::startsWith)) {
                return true;
            }
        }
        Set containerModuleNames = containerLayer.map(layer -> layer.modules().stream().map(Module::getName).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return containerLayer.map(layer -> moduleRef.descriptor().requires().stream().noneMatch(req -> containerModuleNames.contains(req.name()))).orElse(false);
    }

    public static void openToModule(ModuleLayer layer, String moduleName, String bootModuleName, List<String> packages) {
        Class<?> callerClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        String callerClassName = callerClass.getName();
        if (!callerClassName.equals("org.mule.runtime.module.service.api.artifact.ServiceModuleLayerFactory") && !callerClassName.equals("org.mule.runtime.jpms.api.JpmsUtils")) {
            throw new UnsupportedOperationException("This is for internal use only.");
        }
        Module callerModule = JpmsUtils.getCallerModule(callerClass);
        layer.findModule(moduleName).filter(module -> module != callerModule).ifPresent(module -> ModuleLayer.boot().findModule(bootModuleName).ifPresent(bootModule -> {
            for (String pkg : packages) {
                if (!bootModule.getPackages().contains(pkg)) continue;
                bootModule.addOpens(pkg, (Module)module);
            }
        }));
    }

    private static Module getCallerModule(Class<?> caller) {
        return caller != null ? caller.getModule() : null;
    }
}

