/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.model;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.maven.pom.parser.internal.model.PomParentCoordinatesWrapper;

public class MavenPomModelWrapper
implements MavenPomModel {
    private final Model model;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Optional<String> packaging;
    private final Optional<File> pomFile;

    public MavenPomModelWrapper(Model model) {
        this.model = model;
        this.groupId = model.getGroupId();
        this.artifactId = model.getArtifactId();
        this.version = model.getVersion();
        this.packaging = Optional.ofNullable(model.getPackaging());
        this.pomFile = Optional.ofNullable(model.getPomFile());
    }

    public Optional<PomParentCoordinates> getParent() {
        return Optional.ofNullable(this.model.getParent()).map(PomParentCoordinatesWrapper::new);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging.orElse(null);
    }

    public Optional<File> getPomFile() {
        return this.pomFile;
    }

    public Optional<Path> getPomPath() {
        return this.pomFile.map(File::toPath);
    }
}

