/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.maven.pom.parser.api.BundleDescriptorCreationException;
import org.mule.maven.pom.parser.internal.util.FileUtils;

public class MavenUtils {
    private static final String META_INF = "META-INF";
    private static final String MULE_ARTIFACT_FOLDER = "META-INF" + File.separator + "mule-artifact";
    private static final String MULE_PLUGIN_POM = "pom.xml";

    public static Model getPomModel(File artifact) {
        if (artifact.isDirectory()) {
            return MavenUtils.getPomModelFolder(artifact);
        }
        if (FilenameUtils.getExtension((String)artifact.getName()).equals("jar")) {
            URL pomURL = FileUtils.getPomUrlFromJar(artifact);
            return MavenUtils.getPomModelFromJar(pomURL);
        }
        return MavenUtils.getPomModelFromFile(artifact);
    }

    public static Model getPomModelFolder(File artifactFolder) {
        File mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        return MavenUtils.getPomModelFromFile(mulePluginPom);
    }

    public static Model getPomModelFromJar(URL pomUrl) {
        String pomFilePath = MULE_ARTIFACT_FOLDER + File.separator + MULE_PLUGIN_POM;
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((InputStream)new ByteArrayInputStream(FileUtils.loadFileContentFrom(pomUrl).get()));
            return model;
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' for the artifact '%s'", pomFilePath, pomUrl.getFile()), e);
        }
    }

    public static Model getPomModelFromFile(File pomFile) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader mulePluginPomFilerReader = new FileReader(pomFile);){
            model = reader.read((Reader)mulePluginPomFilerReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' in '%s'", pomFile.getName(), pomFile.getParentFile().getAbsolutePath()), e);
        }
        model.setPomFile(pomFile);
        return model;
    }

    private static File lookupPomFromMavenLocation(File artifactFolder) {
        File mulePluginPom = null;
        File lookupFolder = new File(artifactFolder, META_INF + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, MULE_PLUGIN_POM);
            if (possiblePomLocation.exists()) {
                mulePluginPom = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            MavenUtils.checkState(directories != null && directories.length > 0, String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            MavenUtils.checkState(directories.length == 1, String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (mulePluginPom == null || !mulePluginPom.exists()) {
            throw new BundleDescriptorCreationException(String.format("The maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return mulePluginPom;
    }

    public static String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        MavenUtils.checkState(attributeDom != null, String.format("'%s' element not declared at '%s' in the pom file", attributeName, tag.toString()));
        String attributeValue = attributeDom.getValue().trim();
        MavenUtils.checkState(!StringUtils.isEmpty((String)attributeValue), String.format("'%s' was defined but has an empty value at '%s' declared in the pom file", attributeName, tag.toString()));
        return attributeValue;
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

