/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.MavenCommandLineParser;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSettingsSupplierFactory
implements SettingsSupplierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSettingsSupplierFactory.class);
    private static final String SETTINGS_XML = "settings.xml";
    private static final String SETTINGS_SECURITY_XML = "settings-security.xml";
    private static final String MAVEN_GLOBAL_SETTINGS_PATH = "conf" + File.separator + "settings.xml";
    public static final String MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY = "settings.security";
    private final MavenEnvironmentVariables mavenEnvironmentVariables;
    private final MavenCommandLineParser.MavenArguments mavenArguments;

    public DefaultSettingsSupplierFactory(MavenEnvironmentVariables mavenEnvironmentVariables) {
        Objects.requireNonNull(mavenEnvironmentVariables, "mavenEnvironmentVariables cannot be null");
        this.mavenArguments = MavenCommandLineParser.parseMavenArguments(mavenEnvironmentVariables);
        this.mavenEnvironmentVariables = mavenEnvironmentVariables;
    }

    public Optional<File> environmentGlobalSettingsSupplier() {
        File globalSettings;
        File file;
        if (this.mavenArguments.getGlobalSettings().isPresent() && (file = this.mavenArguments.getGlobalSettings().get()).exists()) {
            this.logGlobalSettings(file, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(this.mavenArguments.getGlobalSettings().get());
        }
        File globalSettingsFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(GLOBAL_SETTINGS_SYSTEM_PROPERTY);
        if (globalSettingsFile != null) {
            this.logGlobalSettings(globalSettingsFile, GLOBAL_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(globalSettingsFile);
        }
        String mavenHome = this.mavenEnvironmentVariables.getM2HomeEnv();
        mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeEnv();
        String string = mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeProperty();
        if (mavenHome != null && (globalSettings = new File(mavenHome, MAVEN_GLOBAL_SETTINGS_PATH)).exists()) {
            this.logGlobalSettings(globalSettings, mavenHome);
            return Optional.of(globalSettings);
        }
        return Optional.empty();
    }

    public Optional<File> environmentUserSettingsSupplier() {
        File file;
        File file2;
        if (this.mavenArguments.getSettings().isPresent() && (file2 = this.mavenArguments.getSettings().get()).exists()) {
            this.logUserSettings(file2, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(file2);
        }
        File userSettingsFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(USER_SETTINGS_SYSTEM_PROPERTY);
        if (userSettingsFile != null) {
            this.logUserSettings(userSettingsFile, USER_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(userSettingsFile);
        }
        File userM2Folder = new File(this.mavenEnvironmentVariables.getUserHome(), ".m2");
        if (userM2Folder.exists() && (file = new File(userM2Folder, SETTINGS_XML)).exists()) {
            this.logUserSettings(file, userM2Folder.getAbsolutePath());
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public Optional<File> environmentSettingsSecuritySupplier() {
        File file;
        File settingsSecurityFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY);
        if (settingsSecurityFile != null) {
            this.logSettingsSecurity(settingsSecurityFile, MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY);
            return Optional.of(settingsSecurityFile);
        }
        File userM2Folder = new File(this.mavenEnvironmentVariables.getUserHome(), ".m2");
        if (userM2Folder.exists() && (file = new File(userM2Folder, SETTINGS_SECURITY_XML)).exists()) {
            this.logUserSettings(file, userM2Folder.getAbsolutePath());
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public MavenConfiguration.MavenConfigurationBuilder addToMavenConfig(MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder) {
        Optional<File> globalSettings = this.environmentGlobalSettingsSupplier();
        Optional<File> userSettings = this.environmentUserSettingsSupplier();
        Optional<File> settingsSecurity = this.environmentSettingsSecuritySupplier();
        if (globalSettings.isPresent()) {
            mavenConfigurationBuilder.globalSettingsLocation(globalSettings.get());
        } else {
            LOGGER.info("Maven global settings couldn't be found, M2_HOME environment variable has to be set in order to use global settings (if needed)");
        }
        if (userSettings.isPresent()) {
            mavenConfigurationBuilder.userSettingsLocation(userSettings.get());
        } else {
            LOGGER.info("Maven user settings couldn't be found, this could cause a wrong resolution for dependencies");
        }
        if (settingsSecurity.isPresent()) {
            mavenConfigurationBuilder.settingsSecurityLocation(settingsSecurity.get());
        } else {
            LOGGER.info("Maven settings security couldn't be found");
        }
        if (this.mavenArguments.isStrictChecksums()) {
            mavenConfigurationBuilder.globalChecksumPolicy("fail");
        }
        if (this.mavenArguments.isLaxChecksums()) {
            mavenConfigurationBuilder.globalChecksumPolicy("warn");
        }
        return null;
    }

    private void logSettingsSecurity(File settingsSecurity, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven settings security '{}' from '{}'", (Object)settingsSecurity.getAbsolutePath(), (Object)location);
        }
    }

    private void logUserSettings(File userSettings, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven user settings '{}' from '{}'", (Object)userSettings.getAbsolutePath(), (Object)location);
        }
    }

    private void logGlobalSettings(File globalSettings, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven global settings '{}' from '{}'", (Object)globalSettings.getAbsolutePath(), (Object)location);
        }
    }
}

