/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.version;

import java.util.List;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.mule.maven.client.api.VersionUtils;
import org.mule.maven.client.internal.version.MavenVersion;
import org.mule.maven.client.internal.version.MavenVersionConstraintParser;

public class DefaultVersionUtils
implements VersionUtils {
    public boolean containsVersion(String version, List<String> constraints) throws IllegalArgumentException {
        MavenVersion thisArtifactCoordinatesVersion;
        try {
            thisArtifactCoordinatesVersion = new MavenVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(String.format("Error parsing version %s", version), e);
        }
        return constraints.stream().map(constraint -> {
            try {
                return new MavenVersionConstraintParser((String)constraint);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(String.format("Error parsing constraint %s", constraint), e);
            }
        }).anyMatch(mavenVersionConstraintParser -> mavenVersionConstraintParser.containsVersion(thisArtifactCoordinatesVersion));
    }
}

