/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.util.FileUtils;
import org.mule.maven.client.internal.util.MavenUtils;

public class DefaultPomFileSupplierFactory
implements PomFileSupplierFactory {
    private static final char SEPARATOR = '~';

    public Supplier<File> uncompressPomArtifactSupplier(File artifactFolder, BundleDescriptor artifactBundleDescriptor) {
        return () -> {
            String pathToPom = Paths.get("META-INF", "maven", artifactBundleDescriptor.getGroupId(), artifactBundleDescriptor.getArtifactId(), "pom.xml").toString();
            return new File(artifactFolder, pathToPom);
        };
    }

    public Supplier<File> compressedArtifactSupplier(File artifactFile, BundleDescriptor artifactBundleDescriptor, File temporaryFolder) {
        return () -> {
            try {
                URL pomUrl = MavenUtils.getPomUrlFromJar(artifactFile);
                Optional<byte[]> pomContentOptional = FileUtils.loadFileContentFrom(pomUrl);
                byte[] pomBytes = pomContentOptional.orElseThrow(() -> new RuntimeException(String.format("No pom file found in %s", artifactFile)));
                StringBuilder path = new StringBuilder(128);
                path.append(artifactBundleDescriptor.getGroupId()).append('~');
                path.append(artifactBundleDescriptor.getArtifactId()).append('~');
                path.append(artifactBundleDescriptor.getBaseVersion() != null ? artifactBundleDescriptor.getBaseVersion() : artifactBundleDescriptor.getVersion());
                path.append(".pom");
                File pomLocation = new File(temporaryFolder, path.toString());
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(pomBytes), (File)pomLocation);
                return pomLocation;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

