/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSettingsSupplierFactory
implements SettingsSupplierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSettingsSupplierFactory.class);
    private static final String SETTINGS_XML = "settings.xml";
    private static final String SETTINGS_SECURITY_XML = "settings-security.xml";
    private static final String MAVEN_GLOBAL_SETTINGS_PATH = "conf" + File.separator + "settings.xml";
    public static final String MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY = "settings.security";
    private MavenEnvironmentVariables mavenEnvironmentVariables;

    public DefaultSettingsSupplierFactory(MavenEnvironmentVariables mavenEnvironmentVariables) {
        Objects.requireNonNull(mavenEnvironmentVariables, "mavenEnvironmentVariables cannot be null");
        this.mavenEnvironmentVariables = mavenEnvironmentVariables;
    }

    public Optional<File> environmentGlobalSettingsSupplier() {
        File globalSettings;
        File file;
        MavenArguments mavenArguments = this.parseMavenArguments();
        if (mavenArguments.getGlobalSettings().isPresent() && (file = mavenArguments.getGlobalSettings().get()).exists()) {
            this.logGlobalSettings(file, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(mavenArguments.getGlobalSettings().get());
        }
        File globalSettingsFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(GLOBAL_SETTINGS_SYSTEM_PROPERTY);
        if (globalSettingsFile != null) {
            this.logGlobalSettings(globalSettingsFile, GLOBAL_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(globalSettingsFile);
        }
        String mavenHome = this.mavenEnvironmentVariables.getM2HomeEnv();
        mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeEnv();
        String string = mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeProperty();
        if (mavenHome != null && (globalSettings = new File(mavenHome, MAVEN_GLOBAL_SETTINGS_PATH)).exists()) {
            this.logGlobalSettings(globalSettings, mavenHome);
            return Optional.of(globalSettings);
        }
        return Optional.empty();
    }

    public Optional<File> environmentUserSettingsSupplier() {
        File file;
        File file2;
        MavenArguments mavenArguments = this.parseMavenArguments();
        if (mavenArguments.getSettings().isPresent() && (file2 = mavenArguments.getSettings().get()).exists()) {
            this.logUserSettings(file2, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(file2);
        }
        File userSettingsFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(USER_SETTINGS_SYSTEM_PROPERTY);
        if (userSettingsFile != null) {
            this.logUserSettings(userSettingsFile, USER_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(userSettingsFile);
        }
        File userM2Folder = new File(this.mavenEnvironmentVariables.getUserHome(), ".m2");
        if (userM2Folder.exists() && (file = new File(userM2Folder, SETTINGS_XML)).exists()) {
            this.logUserSettings(file, userM2Folder.getAbsolutePath());
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public Optional<File> environmentSettingsSecuritySupplier() {
        File file;
        File settingsSecurityFile = this.mavenEnvironmentVariables.getFileAsSystemOrEnvProperty(MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY);
        if (settingsSecurityFile != null) {
            this.logSettingsSecurity(settingsSecurityFile, MAVEN_SETTINGS_SECURITY_SYSTEM_PROPERTY);
            return Optional.of(settingsSecurityFile);
        }
        File userM2Folder = new File(this.mavenEnvironmentVariables.getUserHome(), ".m2");
        if (userM2Folder.exists() && (file = new File(userM2Folder, SETTINGS_SECURITY_XML)).exists()) {
            this.logUserSettings(file, userM2Folder.getAbsolutePath());
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private void logSettingsSecurity(File settingsSecurity, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven settings security '{}' from '{}'", (Object)settingsSecurity.getAbsolutePath(), (Object)location);
        }
    }

    private void logUserSettings(File userSettings, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven user settings '{}' from '{}'", (Object)userSettings.getAbsolutePath(), (Object)location);
        }
    }

    private void logGlobalSettings(File globalSettings, String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolved Maven global settings '{}' from '{}'", (Object)globalSettings.getAbsolutePath(), (Object)location);
        }
    }

    private String[] getMavenCmdLineArgs() {
        String mavenCmdLineArgs = this.mavenEnvironmentVariables.getMavenCmdLineArgsEnv();
        if (mavenCmdLineArgs != null) {
            return mavenCmdLineArgs.trim().split(" ");
        }
        return new String[0];
    }

    private MavenArguments parseMavenArguments() {
        MavenArguments mavenArguments = new MavenArguments();
        JCommander.newBuilder().addObject((Object)mavenArguments).acceptUnknownOptions(true).allowParameterOverwriting(true).build().parse(this.getMavenCmdLineArgs());
        return mavenArguments;
    }

    private class MavenArguments {
        @Parameter(names={"-s", "--settings"}, description="User settings")
        private List<File> settings = new ArrayList<File>();
        @Parameter(names={"-gs", "--global-settings"}, description="Global settings")
        private List<File> globalSettings = new ArrayList<File>();

        private MavenArguments() {
        }

        public Optional<File> getSettings() {
            return Optional.ofNullable(this.settings.size() >= 1 ? this.settings.get(0) : null);
        }

        public Optional<File> getGlobalSettings() {
            return Optional.ofNullable(this.globalSettings.size() >= 1 ? this.globalSettings.get(0) : null);
        }
    }
}

