/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSettingsSupplierFactory
implements SettingsSupplierFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSettingsSupplierFactory.class);
    public static final String SETTINGS_XML = "settings.xml";
    public static final String MAVEN_GLOBAL_SETTINGS_PATH = "conf" + File.separator + "settings.xml";
    private MavenEnvironmentVariables mavenEnvironmentVariables;

    public DefaultSettingsSupplierFactory(MavenEnvironmentVariables mavenEnvironmentVariables) {
        Objects.requireNonNull(mavenEnvironmentVariables, "mavenEnvironmentVariables cannot be null");
        this.mavenEnvironmentVariables = mavenEnvironmentVariables;
    }

    public Optional<File> environmentGlobalSettingsSupplier() {
        File globalSettings;
        File file;
        MavenArguments mavenArguments = this.parseMavenArguments();
        if (mavenArguments.getGlobalSettings().isPresent() && (file = mavenArguments.getGlobalSettings().get()).exists()) {
            this.logGlobalSettings(file, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(mavenArguments.getGlobalSettings().get());
        }
        File globalSettingsFile = this.mavenEnvironmentVariables.getSettingsFileAsSystemOrEnvProperty(GLOBAL_SETTINGS_SYSTEM_PROPERTY);
        if (globalSettingsFile != null) {
            this.logGlobalSettings(globalSettingsFile, GLOBAL_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(globalSettingsFile);
        }
        String mavenHome = this.mavenEnvironmentVariables.getM2HomeEnv();
        mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeEnv();
        String string = mavenHome = mavenHome != null ? mavenHome : this.mavenEnvironmentVariables.getMavenHomeProperty();
        if (mavenHome != null && (globalSettings = new File(mavenHome, MAVEN_GLOBAL_SETTINGS_PATH)).exists()) {
            this.logGlobalSettings(globalSettings, mavenHome);
            return Optional.of(globalSettings);
        }
        return Optional.empty();
    }

    public Optional<File> environmentUserSettingsSupplier() {
        File file;
        File file2;
        MavenArguments mavenArguments = this.parseMavenArguments();
        if (mavenArguments.getSettings().isPresent() && (file2 = mavenArguments.getSettings().get()).exists()) {
            this.logUserSettings(file2, "MAVEN_CMD_LINE_ARGS");
            return Optional.of(file2);
        }
        File userSettingsFile = this.mavenEnvironmentVariables.getSettingsFileAsSystemOrEnvProperty(USER_SETTINGS_SYSTEM_PROPERTY);
        if (userSettingsFile != null) {
            this.logUserSettings(userSettingsFile, USER_SETTINGS_SYSTEM_PROPERTY);
            return Optional.of(userSettingsFile);
        }
        File userM2Folder = new File(this.mavenEnvironmentVariables.getUserHome(), ".m2");
        if (userM2Folder.exists() && (file = new File(userM2Folder, SETTINGS_XML)).exists()) {
            this.logUserSettings(file, userM2Folder.getAbsolutePath());
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private void logUserSettings(File userSettings, String location) {
        LOGGER.debug("Resolved Maven user settings '{}' from '{}'", (Object)userSettings.getAbsolutePath(), (Object)location);
    }

    private void logGlobalSettings(File globalSettings, String location) {
        LOGGER.debug("Resolved Maven global settings '{}' from '{}'", (Object)globalSettings.getAbsolutePath(), (Object)location);
    }

    private String[] getMavenCmdLineArgs() {
        String mavenCmdLineArgs = this.mavenEnvironmentVariables.getMavenCmdLineArgsEnv();
        if (mavenCmdLineArgs != null) {
            return mavenCmdLineArgs.trim().split(" ");
        }
        return new String[0];
    }

    private MavenArguments parseMavenArguments() {
        MavenArguments mavenArguments = new MavenArguments();
        JCommander.newBuilder().addObject((Object)mavenArguments).acceptUnknownOptions(true).build().parse(this.getMavenCmdLineArgs());
        return mavenArguments;
    }

    private class MavenArguments {
        @Parameter(names={"-s", "--settings"}, description="User settings")
        private File settings = null;
        @Parameter(names={"-gs", "--global-settings"}, description="Global settings")
        private File globalSettings = null;

        private MavenArguments() {
        }

        public Optional<File> getSettings() {
            return Optional.ofNullable(this.settings);
        }

        public Optional<File> getGlobalSettings() {
            return Optional.ofNullable(this.globalSettings);
        }
    }
}

