/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Model;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherRepositoryState;
import org.mule.maven.client.internal.AetherResolutionContext;
import org.mule.maven.client.internal.DefaultPomFileSupplierFactory;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.maven.client.internal.util.Preconditions;
import org.mule.maven.client.internal.util.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherMavenClient
implements MavenClient {
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherMavenClient.class);
    private static final String POM = "pom";
    private static final Consumer<DefaultRepositorySystemSession> NO_OP = _x -> {};
    private MavenConfiguration mavenConfiguration;
    private AetherResolutionContext aetherResolutionContext;
    private PomFileSupplierFactory pomFileSupplierFactory = new DefaultPomFileSupplierFactory();
    private Optional<Consumer<DefaultRepositorySystemSession>> sessionConfigurator = Optional.empty();

    public AetherMavenClient(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        this.aetherResolutionContext = new AetherResolutionContext(mavenConfiguration);
    }

    private AetherRepositoryState getRepositoryState(Optional<WorkspaceReader> workspaceReader) {
        return this.getRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), workspaceReader);
    }

    private AetherRepositoryState getRepositoryState(File localRepositoryLocation, Optional<WorkspaceReader> workspaceReader) {
        AetherRepositoryState repositoryState = new AetherRepositoryState(localRepositoryLocation, workspaceReader, this.aetherResolutionContext.getAuthenticatorSelector(), this.mavenConfiguration.getForcePolicyUpdateNever(), this.mavenConfiguration.getOfflineMode(), this.sessionConfigurator.orElse(NO_OP));
        return repositoryState;
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public void setSessionConfigurator(Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.sessionConfigurator = Optional.of(sessionConfigurator);
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        return this.resolveArtifactDependencies(artifactFile, includeTestDependencies, true, localRepositoryLocationSupplier, temporaryFolder);
    }

    private List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        Supplier pomFileSupplier;
        Model pomModel = MavenUtils.getPomModel(artifactFile);
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor(pomModel);
        if (artifactFile.isDirectory()) {
            pomFileSupplier = this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor);
        } else {
            Preconditions.checkState(temporaryFolder.isPresent(), "temporary folder not provided but the artifact is compressed");
            pomFileSupplier = this.pomFileSupplierFactory.compressedArtifactSupplier(artifactFile, bundleDescriptor, temporaryFolder.get());
        }
        File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.aetherResolutionContext.getLocalRepositoryLocation());
        AetherRepositoryState repositoryState = this.getRepositoryState(localRepositoryLocation, Optional.of(new PomWorkspaceReader(bundleDescriptor, artifactFile, pomFileSupplier)));
        DefaultArtifact artifact = new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), null, POM, pomModel.getVersion() != null ? pomModel.getVersion() : pomModel.getParent().getVersion());
        try {
            return this.resolveArtifactDependencies(includeTestDependencies, includeProvidedDependencies, repositoryState, (Artifact)artifact);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(String.format("There was an issue resolving the dependency tree for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (ArtifactDescriptorException e) {
            throw new RuntimeException(String.format("There was an issue resolving the artifact descriptor for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private List<BundleDependency> resolveArtifactDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, AetherRepositoryState repositoryState, Artifact artifact) throws RepositoryException {
        ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
        return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, BundleDescriptor bundleDescriptor) {
        return this.resolveBundleDescriptorDependencies(includeTestDependencies, false, bundleDescriptor);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
        try {
            AetherRepositoryState repositoryState = this.getRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
            return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies);
        }
        catch (RepositoryException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    public List<BundleDependency> resolveBundleDescriptorDependenciesWithWorkspaceReader(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
        Supplier pomFileSupplier = this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor);
        try {
            AetherRepositoryState repositoryState = this.getRepositoryState(Optional.of(new PomWorkspaceReader(bundleDescriptor, artifactFile, pomFileSupplier)));
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
            return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies);
        }
        catch (RepositoryException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    private Artifact createArtifactFromBundleDescriptor(BundleDescriptor bundleDescriptor) {
        return new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion());
    }

    public BundleDependency resolveBundleDescriptor(BundleDescriptor bundleDescriptor) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving artifact with resolution context: " + this.aetherResolutionContext.toString());
            }
            AetherRepositoryState repositoryState = this.getRepositoryState(Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null);
            ArtifactResult artifactResult = repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            return AetherMavenClient.artifactToBundleDependency(resolvedArtifact, "compile");
        }
        catch (ArtifactResolutionException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    public Model getRawPomModel(File artifactFile) {
        return MavenUtils.getPomModel(artifactFile);
    }

    public List<BundleDependency> resolvePluginBundleDescriptorsDependencies(List<BundleDescriptor> bundleDescriptors) {
        HashMap plugins = new HashMap();
        bundleDescriptors.stream().map(this::resolveBundleDescriptor).forEach(directBundleDependency -> {
            this.checkAndUpdatePluginVersion((BundleDependency)directBundleDependency, plugins);
            List<BundleDependency> bundleDependencies = this.resolveBundleDescriptorDependencies(false, directBundleDependency.getDescriptor());
            bundleDependencies.stream().filter(bundleDependency -> MULE_PLUGIN_CLASSIFIER.equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).forEach(bundleDependency -> this.checkAndUpdatePluginVersion((BundleDependency)bundleDependency, plugins));
        });
        return plugins.values().stream().collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndUpdatePluginVersion(BundleDependency bundleDependency, Map<Pair<String, String>, BundleDependency> plugins) {
        Pair<String, String> key = this.descriptorToPair(bundleDependency);
        if (plugins.containsKey(key)) {
            String bundleDescriptorVersion;
            BundleDependency existentDependency = plugins.get(key);
            String existentBundleDescriptorVersion = existentDependency.getDescriptor().getVersion();
            if (!VersionChecker.areCompatibleVersions(existentBundleDescriptorVersion, bundleDescriptorVersion = bundleDependency.getDescriptor().getVersion())) throw new RuntimeException(String.format("Incompatible versions between plugin %s and %s", existentDependency.getDescriptor(), bundleDependency.getDescriptor()));
            String highestVersion = VersionChecker.getHighestVersion(existentBundleDescriptorVersion, bundleDescriptorVersion);
            if (!highestVersion.equals(bundleDescriptorVersion)) return;
            plugins.put(key, bundleDependency);
            return;
        } else {
            plugins.put(key, bundleDependency);
        }
    }

    private Pair<String, String> descriptorToPair(BundleDependency bundleDependency) {
        return Pair.of((Object)bundleDependency.getDescriptor().getGroupId(), (Object)bundleDependency.getDescriptor().getArtifactId());
    }

    static BundleDependency artifactToBundleDependency(Artifact artifact, String scope) {
        BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension());
        String classifier = artifact.getClassifier();
        if (!org.eclipse.aether.util.StringUtils.isEmpty((String)classifier)) {
            bundleDescriptorBuilder.setClassifier(classifier);
        }
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(bundleDescriptorBuilder.build()).setScope(BundleScope.valueOf((String)scope.toUpperCase()));
        if (!scope.equalsIgnoreCase("provided")) {
            builder.setBundleUri(artifact.getFile().toURI());
        }
        return builder.build();
    }

    private ArtifactResult readArtifactDescriptor(Artifact artifact, AetherRepositoryState repositoryState) throws ArtifactResolutionException {
        return repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), new ArtifactRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null));
    }

    private List<BundleDependency> assemblyDependenciesFromPom(AetherRepositoryState repositoryState, Artifact artifact, boolean enableTestDependencies, boolean enableProvidedDependencies) throws RepositoryException {
        String[] stringArray;
        DefaultArtifact defaultArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, POM, artifact.getVersion() != null ? artifact.getVersion() : artifact.getVersion());
        LOGGER.info("About to fetch required dependencies for artifact: {}. This may take a while...", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact));
        CollectRequest collectRequest = new CollectRequest();
        ArtifactDescriptorResult artifactDescriptorResult = repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)repositoryState.getSession(), new ArtifactDescriptorRequest((Artifact)defaultArtifact, null, null).setRepositories(this.aetherResolutionContext.getRemoteRepositories()));
        List dependencies = artifactDescriptorResult.getDependencies();
        List requestedDependencies = dependencies.stream().filter(dependency -> enableTestDependencies && dependency.getScope().equalsIgnoreCase("test") || dependency.getScope().equalsIgnoreCase("compile") || enableProvidedDependencies && dependency.getScope().equalsIgnoreCase("provided")).collect(Collectors.toList());
        LOGGER.debug("Resolving dependencies for: {} from list of dependencies: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact), requestedDependencies);
        collectRequest.setDependencies(requestedDependencies);
        collectRequest.setManagedDependencies(artifactDescriptorResult.getManagedDependencies());
        collectRequest.setRepositories(this.aetherResolutionContext.getRemoteRepositories());
        LOGGER.debug("Collecting transitive dependencies of artifact: {} using request: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact), (Object)collectRequest);
        CollectResult collectResult = repositoryState.getSystem().collectDependencies((RepositorySystemSession)repositoryState.getSession(), collectRequest);
        if (enableTestDependencies) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "provided";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "provided";
            stringArray = stringArray3;
            stringArray3[1] = "test";
        }
        ScopeDependencyFilter transitiveDependenciesFilter = new ScopeDependencyFilter(stringArray);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setFilter((DependencyFilter)transitiveDependenciesFilter);
        dependencyRequest.setRoot(collectResult.getRoot());
        dependencyRequest.setCollectRequest(collectRequest);
        LOGGER.debug("Collecting and resolving transitive dependencies of artifact: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact));
        DependencyResult dependencyResult = repositoryState.getSystem().resolveDependencies((RepositorySystemSession)repositoryState.getSession(), dependencyRequest);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        dependencyResult.getRoot().accept((DependencyVisitor)nlg);
        return nlg.getNodes().stream().map(node -> AetherMavenClient.artifactToBundleDependency(node.getArtifact(), node.getDependency().getScope())).collect(Collectors.toList());
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty()) {
                LOGGER.warn("Dependency path to not resolved artifacts -> " + unresolvedArtifactPath.toString());
            }
        });
    }

    private BundleDescriptor getBundleDescriptor(Model pomModel) {
        String version = StringUtils.isNotBlank((CharSequence)pomModel.getVersion()) ? pomModel.getVersion() : pomModel.getParent().getVersion();
        return new BundleDescriptor.Builder().setGroupId(StringUtils.isNotBlank((CharSequence)pomModel.getGroupId()) ? pomModel.getGroupId() : pomModel.getParent().getGroupId()).setArtifactId(pomModel.getArtifactId()).setVersion(version).setBaseVersion(version).setType(POM).build();
    }

    private class PomWorkspaceReader
    implements WorkspaceReader {
        final WorkspaceRepository workspaceRepository;
        private final BundleDescriptor bundleDescriptor;
        private final Supplier<File> pomFileSupplier;

        PomWorkspaceReader(BundleDescriptor bundleDescriptor, File artifactFile, Supplier<File> pomFileSupplier) {
            this.bundleDescriptor = bundleDescriptor;
            this.workspaceRepository = new WorkspaceRepository(String.format("worskpace-repository-%s", artifactFile.getName()));
            this.pomFileSupplier = pomFileSupplier;
        }

        public WorkspaceRepository getRepository() {
            return this.workspaceRepository;
        }

        public File findArtifact(Artifact artifact) {
            if (this.checkArtifact(artifact)) {
                return this.pomFileSupplier.get();
            }
            return null;
        }

        public List<String> findVersions(Artifact artifact) {
            if (this.checkArtifact(artifact)) {
                return Collections.singletonList(artifact.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(Artifact artifact) {
            return this.bundleDescriptor.getGroupId().equals(artifact.getGroupId()) && this.bundleDescriptor.getArtifactId().equals(artifact.getArtifactId()) && this.bundleDescriptor.getVersion().equals(artifact.getVersion()) && this.bundleDescriptor.getType().equals(artifact.getExtension());
        }
    }
}

