/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        JarURLConnection jarConnection = (JarURLConnection)jarFile.openConnection();
        try (InputStream inputStream = jarConnection.getInputStream();){
            byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
            Optional<byte[]> optional = Optional.of(byteArray);
            return optional;
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI().toString() + "!/" + filePath);
    }

    public static List<URL> getUrlsWithinJar(File file, String directory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(directory + "/")) continue;
                urls.add(FileUtils.getUrlWithinJar(file, jarEntry.getName()));
            }
        }
        return urls;
    }
}

