/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.net.URL;
import java.util.Optional;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.api.util.Preconditions;

class ImmutableRemoteRepository
implements RemoteRepository {
    private String id;
    private URL url;
    private Authentication authentication;

    public ImmutableRemoteRepository(String id, URL url, Optional<Authentication> authentication) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(url, "url cannot be null");
        this.id = id;
        this.url = url;
        this.authentication = authentication.orElse(null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return Optional.ofNullable(this.authentication);
    }

    public String toString() {
        return "ImmutableRemoteRepository{id='" + this.id + '\'' + ", url=" + this.url + ", authentication=" + this.authentication + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRemoteRepository that = (ImmutableRemoteRepository)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        return this.authentication != null ? this.authentication.equals(that.authentication) : that.authentication == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + (this.authentication != null ? this.authentication.hashCode() : 0);
        return result;
    }
}

