/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.context;

import java.io.IOException;
import org.mule.extension.spring.api.ArtifactPropertiesPlaceholder;
import org.mule.extension.spring.internal.beanfactory.ArtifactObjectsAwareBeanFactory;
import org.mule.extension.spring.internal.context.ResourceDelegate;
import org.mule.extension.spring.internal.inject.MuleAwareObjectsInjectorProcessor;
import org.mule.runtime.api.ioc.ObjectProviderConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;

public class SpringModuleApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String AUTOWIRED_POST_PROCESSOR_OBJECT_KEY = "_autowiredPostProcessor";
    private static final String ARTIFACT_PROPERTY_PLACEHOLDER_OBJECT_KEY = "_artifactPropertyPlaceholder";
    private ObjectProviderConfiguration configuration;
    private ArtifactObjectsAwareBeanFactory beanFactory;

    public SpringModuleApplicationContext(String[] configLocations, ObjectProviderConfiguration configuration) throws BeansException {
        super(configLocations, false);
        this.configuration = configuration;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws BeansException, IOException {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory){

            public int loadBeanDefinitions(Resource resource) throws BeanDefinitionStoreException {
                return super.loadBeanDefinitions((Resource)new ResourceDelegate(resource));
            }
        };
        beanDefinitionReader.setEnvironment((Environment)this.getEnvironment());
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        this.beanFactory = new ArtifactObjectsAwareBeanFactory(this.getInternalParentBeanFactory(), this.configuration.getArtifactObjectProvider());
        return this.beanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        defaultListableBeanFactory.registerBeanDefinition("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(MuleAwareObjectsInjectorProcessor.class).getBeanDefinition());
        defaultListableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
        defaultListableBeanFactory.registerBeanDefinition(AUTOWIRED_POST_PROCESSOR_OBJECT_KEY, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class).getBeanDefinition());
        this.registerArtifactPropertiesPlaceholder(defaultListableBeanFactory, this.configuration);
    }

    private void registerArtifactPropertiesPlaceholder(DefaultListableBeanFactory defaultListableBeanFactory, ObjectProviderConfiguration configuration) {
        BeanDefinitionBuilder artifactPlaceholderBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(ArtifactPropertiesPlaceholder.class).addConstructorArgValue((Object)configuration.getConfigurationProperties());
        defaultListableBeanFactory.registerBeanDefinition(ARTIFACT_PROPERTY_PLACEHOLDER_OBJECT_KEY, (BeanDefinition)artifactPlaceholderBeanDefinitionBuilder.getBeanDefinition());
    }

    public void close() {
        this.beanFactory.markForDestroy();
        super.close();
    }
}

