/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.module.soapkit.internal.DefaultSoapServerHandler;
import org.mule.module.soapkit.internal.SoapkitConfiguration;
import org.mule.module.soapkit.internal.SoapkitRouterAttributes;
import org.mule.module.soapkit.internal.exception.SoapkitRouterException;
import org.mule.module.soapkit.internal.exception.SubFlowFailureException;
import org.mule.module.soapkit.internal.exception.error.SoapkitExceptionEnricher;
import org.mule.module.soapkit.internal.util.HttpListenerUtils;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.runtime.privileged.StreamingHelperFactory;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.internal.message.DefaultSoapRequest;
import org.mule.soapkit.soap.api.server.SoapServerHandler;
import org.mule.soapkit.soap.message.SoapAttributes;
import org.mule.soapkit.soap.message.SoapResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SoapkitRouterExecutor
implements ComponentExecutor<OperationModel> {
    private static final String MESSAGE_PARAM = "message";
    private static final String OPERATION = "soapkit-operation";
    @Inject
    private ConfigurationComponentLocator componentLocator;
    private final SoapkitExceptionEnricher exceptionEnricher = new SoapkitExceptionEnricher();
    private final StreamingHelperFactory streamingHelperFactory = new StreamingHelperFactory();

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        try {
            ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
            CoreEvent event = context.getEvent();
            ConfigurationInstance configuration = this.getConfiguration((ExecutionContextAdapter<OperationModel>)context);
            SoapkitConfiguration config = (SoapkitConfiguration)configuration.getValue();
            StreamingHelper streamingHelper = this.streamingHelperFactory.resolve((ExecutionContext)context);
            InputStream message = (InputStream)context.getParameter(MESSAGE_PARAM);
            SoapkitRouterAttributes attributes = SoapkitRouterAttributes.create((ExecutionContextAdapter<OperationModel>)context, this.componentLocator, config.getAddress());
            Map<String, String> transportHeaders = attributes.getTransportHeaders();
            DefaultSoapRequest request = SoapRequest.builder().operation(OPERATION).content(message).contentType(HttpListenerUtils.getContentTypeWithCharset(transportHeaders, "mule.soap.http.headers.content-type").toString()).transportHeaders(transportHeaders).build();
            DefaultSoapServerHandler serverHandler = new DefaultSoapServerHandler(event, config, streamingHelper, this.componentLocator);
            SoapResponse response = config.getSoapServer().serve((SoapRequest)request, (SoapServerHandler)serverHandler);
            Object messageValue = streamingHelper.resolveCursorProvider((Object)response.getContent());
            return Mono.justOrEmpty((Object)this.eventResult(event, response, messageValue));
        }
        catch (ComponentExecutionException e) {
            return Mono.error((Throwable)((Object)SubFlowFailureException.newInstance(e)));
        }
        catch (Exception e) {
            return Mono.error((Throwable)this.exceptionEnricher.enrich(e));
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal((Throwable)t));
        }
    }

    private ConfigurationInstance getConfiguration(ExecutionContextAdapter<OperationModel> context) {
        Optional configuration = context.getConfiguration();
        if (configuration.isPresent()) {
            return (ConfigurationInstance)configuration.get();
        }
        throw new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)"Could not found apikit-soap configuration to execute the request"));
    }

    private CoreEvent eventResult(CoreEvent parent, SoapResponse response, Object value) {
        Message message = Message.builder((Message)parent.getMessage()).value(value).attributesValue((Object)this.buildAttributes(response)).build();
        return CoreEvent.builder((CoreEvent)parent).variables(response.getVariables()).message(message).build();
    }

    private SoapAttributes buildAttributes(SoapResponse response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(response.getTransportHeaders());
        Charset charset = HttpListenerUtils.getContentTypeWithCharset(headers, "Content-Type").getCharset().orElse(Charset.defaultCharset());
        headers.put("Content-Type", response.getContentType());
        return new SoapAttributes(headers, response.getTransportAdditionalData());
    }
}

