/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import java.net.URL;
import java.util.Map;
import org.mule.module.soapkit.internal.SoapkitOperations;
import org.mule.module.soapkit.internal.WsdlConnectionInfo;
import org.mule.module.soapkit.internal.values.WsdlValueProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.soap.api.SoapVersion;
import org.mule.soapkit.soap.SoapServiceImplementation;
import org.mule.soapkit.soap.api.param.ValidationLevel;
import org.mule.soapkit.soap.api.server.SoapServer;
import org.mule.soapkit.soap.api.server.SoapServerConfiguration;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.SoapBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration(name="config")
@Operations(value={SoapkitOperations.class})
@DisplayName(value="Configuration")
public class SoapkitConfiguration
implements Startable,
Stoppable {
    public static final String CONFIG_NAME = "config";
    @RefName
    private String name;
    @ParameterGroup(name="Connection")
    @OfValues(value=WsdlValueProvider.class)
    private WsdlConnectionInfo info;
    @Parameter
    @Placement(order=5)
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SoapVersion soapVersion;
    @Parameter
    @Optional
    @Placement(order=6)
    private String address;
    @Parameter
    @Placement(order=7)
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean mtomEnabled;
    @Parameter
    @Placement(order=8)
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean inboundValidationEnabled;
    @Parameter
    @Placement(order=9)
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean responseXMLDeclarationEnabled;
    @Parameter
    @Placement(order=10)
    @Optional(defaultValue="WARN")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ValidationLevel inboundValidationMessageLevel;
    @Parameter
    @Placement(order=11)
    @Optional(defaultValue="httpStatus")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String httpStatusVarName;
    @Parameter
    @Placement(order=12)
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Map<String, String> namespacePrefixes;
    private SoapServer soapServer = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapkitConfiguration.class);

    public String getName() {
        return this.name;
    }

    public WsdlConnectionInfo getInfo() {
        return this.info;
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public boolean isInboundValidationEnabled() {
        return this.inboundValidationEnabled;
    }

    public void setInfo(WsdlConnectionInfo info) {
        this.info = info;
    }

    SoapServer getSoapServer() {
        return this.soapServer;
    }

    public void start() throws MuleException {
        try {
            PortModel portModel = this.validate();
            this.soapServer = new SoapServiceImplementation().getServerFactory().create(this.getConfiguration());
            this.soapServer.start();
            this.soapVersion = this.getSoapVersion(portModel);
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Error connecting Soap Server for config '%s'", this.name), (Throwable)e);
        }
    }

    public void stop() throws MuleException {
        try {
            if (this.soapServer != null) {
                this.soapServer.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error disconnecting soap soapServer [" + this.soapServer.toString() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private SoapServerConfiguration getConfiguration() throws ConnectionException {
        URL wsdlUrl = this.info.getWsdlLocationUrl();
        return SoapServerConfiguration.builder().withWsdlLocation(wsdlUrl).withService(this.info.getService()).withPort(this.info.getPort()).withNamespaces(this.namespacePrefixes).enableMtom(this.mtomEnabled).enableValidation(this.inboundValidationEnabled).enableResponseXMLDeclaration(this.responseXMLDeclarationEnabled).withValidationErrorLevel(this.inboundValidationMessageLevel).build();
    }

    private PortModel validate() throws ConnectionException {
        return this.getInfo().validate();
    }

    public SoapVersion getSoapVersion(PortModel portModel) {
        SoapBinding binding = portModel.getBinding();
        if (binding == null) {
            return SoapVersion.SOAP_11;
        }
        return binding.getVersion().name().equals("SOAP12") ? SoapVersion.SOAP_12 : SoapVersion.SOAP_11;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHttpStatusVarName() {
        return this.httpStatusVarName;
    }
}

