/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.local.LocalConduit;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soapkit.soap.api.param.ValidationLevel;
import org.mule.soapkit.soap.api.server.SoapServer;
import org.mule.soapkit.soap.api.server.SoapServerHandler;
import org.mule.soapkit.soap.message.EmptySoapResponse;
import org.mule.soapkit.soap.message.ImmutableSoapResponse;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.server.support.DelegatingOutputStream;
import org.mule.soapkit.soap.util.DataHandlerUtils;
import org.mule.wsdl.parser.model.PortModel;

public class SoapCxfServer
implements SoapServer {
    private final Server server;
    private final PortModel portModel;
    private final boolean mtomEnabled;
    private final boolean validationEnabled;
    private final ValidationLevel validationLevel;
    private static final String WSDL = "wsdl";
    private static final String XSD = "xsd";
    private static final String SOAP_ACTION = "SOAPAction";
    public static final String STATUS_CODE = "statusCode";
    public static final String HTTP_STATUS_PROTOCOL_HEADER = "httpStatus";

    public SoapCxfServer(Server server, PortModel portModel, boolean mtomEnabled, boolean validationEnabled, ValidationLevel validationLevel) {
        this.server = server;
        this.portModel = portModel;
        this.mtomEnabled = mtomEnabled;
        this.validationEnabled = validationEnabled;
        this.validationLevel = validationLevel;
    }

    static SoapCxfServer create(Server server, PortModel portModel, boolean mtomEnabled, boolean validationEnabled, ValidationLevel validationLevel) {
        return new SoapCxfServer(server, portModel, mtomEnabled, validationEnabled, validationLevel);
    }

    @Override
    public SoapResponse serve(SoapRequest request, SoapServerHandler handler) {
        Exchange exchange = this.sendThroughCxf(request, handler);
        return this.toSoapResponse(exchange, handler);
    }

    @Override
    public String getPort() {
        return this.portModel.getName();
    }

    @Override
    public QName getService() {
        return this.server.getEndpoint().getService().getName();
    }

    private Exchange sendThroughCxf(SoapRequest request, SoapServerHandler handler) {
        ExchangeImpl exchange = new ExchangeImpl();
        MessageImpl messageIn = new MessageImpl();
        messageIn.setExchange((Exchange)exchange);
        if (this.validationEnabled) {
            messageIn.put("org.apache.cxf.client", (Object)Boolean.FALSE);
            messageIn.put("schema-validation-enabled", (Object)SchemaValidation.SchemaValidationType.REQUEST);
        }
        exchange.put((Object)"mule.soap.server.handler", (Object)handler);
        Map transportHeaders = request.getTransportHeaders();
        String method = (String)transportHeaders.get("mule.soap.http.attributes.method");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)method)) {
            messageIn.put("org.apache.cxf.request.method", (Object)method);
        }
        boolean isGetMethod = "GET".equalsIgnoreCase(method);
        String contentType = (String)transportHeaders.get("mule.soap.http.headers.content-type");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contentType)) {
            messageIn.put("Content-Type", (Object)contentType);
        }
        boolean isMtom = this.mtomEnabled || contentType != null && contentType.contains("application/xop+xml");
        messageIn.put("mtom-enabled", (Object)(isMtom ? Boolean.TRUE : Boolean.FALSE));
        String queryString = (String)transportHeaders.get("mule.soap.http.attributes.query.string");
        boolean isWsdlOrXsdRequest = false;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryString)) {
            messageIn.put(Message.QUERY_STRING, (Object)queryString);
            boolean bl = isWsdlOrXsdRequest = isGetMethod && this.isWSDLOrXSDRequest(queryString);
        }
        if (isWsdlOrXsdRequest) {
            String location = (String)transportHeaders.get("mule.soap.http.attributes.location");
            if (location != null) {
                messageIn.put("org.apache.cxf.request.url", (Object)location);
            }
        } else {
            Map<String, List> protocolHeaders = request.getTransportHeaders().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("mule.soap.http.headers.")).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("mule.soap.http.headers.", ""), e -> Strings.isNullOrEmpty((String)((String)e.getValue())) ? Collections.emptyList() : Collections.singletonList((String)e.getValue())));
            Optional<String> soapAction = this.getSoapAction(request.getTransportHeaders());
            soapAction.ifPresent(action -> {
                protocolHeaders.remove(SOAP_ACTION.toLowerCase());
                protocolHeaders.put(SOAP_ACTION, Collections.singletonList(action));
                messageIn.put(SOAP_ACTION, action);
            });
            messageIn.put(Message.PROTOCOL_HEADERS, protocolHeaders);
            Map<String, Attachment> attachments = this.transformToCxfAttachments(request.getAttachments());
            messageIn.setAttachments(attachments.values());
            this.setContent(request, (Message)messageIn);
        }
        Destination d = this.server.getDestination();
        messageIn.put(LocalConduit.DIRECT_DISPATCH, (Object)Boolean.TRUE);
        messageIn.setDestination(d);
        exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        exchange.setInMessage((Message)messageIn);
        d.getMessageObserver().onMessage((Message)messageIn);
        Exception exception = (Exception)exchange.get(Exception.class);
        if (exception != null) {
            Optional validationException;
            Optional cause = ExceptionUtils.extractOfType((Throwable)exception, ComponentExecutionException.class);
            if (cause.isPresent()) {
                throw (ComponentExecutionException)cause.get();
            }
            if (this.validationEnabled && ValidationLevel.ERROR.equals((Object)this.validationLevel) && (validationException = ExceptionUtils.extractOfType((Throwable)exception, Fault.class)).isPresent() && ((Fault)validationException.get()).getFaultCode().equals(Fault.FAULT_CODE_CLIENT)) {
                throw (Fault)validationException.get();
            }
        }
        if (isWsdlOrXsdRequest && exchange.getOutMessage() != null) {
            String contentTypeOut = (String)exchange.getOutMessage().get((Object)"Content-Type");
            exchange.put((Object)"Content-Type", (Object)contentTypeOut);
        }
        return exchange;
    }

    private boolean isWSDLOrXSDRequest(String queryString) {
        Map queryStringMap = UrlUtils.parseQueryString((String)queryString);
        return queryStringMap.containsKey(WSDL) || queryStringMap.containsKey(XSD);
    }

    private SoapResponse toSoapResponse(Exchange exchange, SoapServerHandler handler) {
        MediaType contentType;
        InputStream is;
        Message contentMsg;
        Message outMessage = exchange.getOutMessage();
        Message outFaultMessage = exchange.getOutFaultMessage();
        SoapResponse soapResponse = Optional.ofNullable((SoapResponse)exchange.get((Object)"mule.soap.server.response")).orElse(new EmptySoapResponse(handler.getVariables()));
        HashMap<String, String> transportAdditionalData = new HashMap<String, String>(soapResponse.getTransportAdditionalData());
        HashMap<String, String> transportHeaders = new HashMap<String, String>(soapResponse.getTransportHeaders());
        if (outFaultMessage != null && outFaultMessage.getContent(DelegatingOutputStream.class) != null) {
            contentMsg = outFaultMessage;
            transportAdditionalData.put(STATUS_CODE, String.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
            transportHeaders.put(HTTP_STATUS_PROTOCOL_HEADER, String.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        } else {
            contentMsg = outMessage;
        }
        DelegatingOutputStream response = (DelegatingOutputStream)contentMsg.getContent(DelegatingOutputStream.class);
        if (response != null) {
            ByteArrayOutputStream os = (ByteArrayOutputStream)response.getOutputStream();
            is = new ByteArrayInputStream(os.toByteArray());
            contentType = this.getContentType(contentMsg);
        } else {
            is = soapResponse.getContent();
            contentType = MediaType.parse((String)soapResponse.getContentType());
        }
        return new ImmutableSoapResponse(is, soapResponse.getSoapHeaders(), transportHeaders, transportAdditionalData, soapResponse.getAttachments(), contentType, soapResponse.getVariables());
    }

    private MediaType getContentType(Message contentMsg) {
        String contentType = (String)contentMsg.get((Object)"Content-Type");
        String encoding = Optional.ofNullable((String)contentMsg.get((Object)Message.ENCODING)).orElse(Charset.defaultCharset().name());
        return Strings.isNullOrEmpty((String)contentType) ? MediaType.XML : MediaType.parse((String)contentType).withCharset(this.getEncoding(encoding));
    }

    public Server getServer() {
        return this.server;
    }

    private Optional<String> getSoapAction(Map<String, String> transportHeaders) {
        String action = transportHeaders.get("mule.soap.http.headers.soapAction".toLowerCase());
        if (action != null && action.startsWith("\"") && action.endsWith("\"") && action.length() >= 2) {
            action = action.substring(1, action.length() - 1);
        }
        return Optional.ofNullable(action);
    }

    private Map<String, Attachment> transformToCxfAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            try {
                builder.put(name, (Object)new AttachmentImpl(name, DataHandlerUtils.toDataHandler(name, value.getContent(), MediaType.parse((String)value.getContentType()))));
            }
            catch (IOException e) {
                throw new BadResponseException(String.format("Error while preparing attachment [%s]", name), (Throwable)e);
            }
        });
        return builder.build();
    }

    private void setContent(SoapRequest request, Message message) {
        InputStream payload = request.getContent();
        message.put((Object)Message.ENCODING, (Object)this.getEncoding(request).name());
        InputStream content = payload instanceof CursorStreamProvider ? ((CursorStreamProvider)payload).openCursor() : payload;
        message.setContent(InputStream.class, (Object)content);
    }

    private Charset getEncoding(String encoding) {
        try {
            return Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException e) {
            return Charset.defaultCharset();
        }
    }

    @NotNull
    private Charset getEncoding(SoapRequest request) {
        Charset charSet;
        String contentType = (String)request.getTransportHeaders().get("mule.soap.http.headers.content-type");
        if (StringUtils.isEmpty((String)contentType)) {
            return Charset.defaultCharset();
        }
        try {
            charSet = MediaType.parse((String)contentType).getCharset().orElse(Charset.defaultCharset());
        }
        catch (IllegalArgumentException e) {
            charSet = Charset.defaultCharset();
        }
        return charSet;
    }

    public void start() {
        this.getServer().start();
    }

    public void stop() {
        this.getServer().destroy();
    }
}

