/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.message;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soapkit.soap.message.AbstractSoapResponse;
import org.mule.soapkit.soap.message.SubFlowResponse;
import org.mule.soapkit.soap.util.Cast;

public final class ImmutableSoapResponse
extends AbstractSoapResponse {
    private final InputStream content;
    private final Map<String, String> soapHeaders;
    private final Map<String, SoapAttachment> attachments;
    private final MediaType contentType;
    private Event event;

    public ImmutableSoapResponse(InputStream content, Map<String, String> soapHeaders, Map<String, String> transportHeaders, Map<String, String> transportAdditionalData, Map<String, SoapAttachment> attachments, MediaType contentType, Map<String, TypedValue<?>> variables) {
        super(transportHeaders, transportAdditionalData, variables);
        this.content = content;
        this.soapHeaders = Collections.unmodifiableMap(soapHeaders);
        this.attachments = Collections.unmodifiableMap(attachments);
        this.contentType = contentType;
    }

    public ImmutableSoapResponse(Event event, Map<String, String> transportHeaders, Map<String, String> transportAdditionalData, MediaType contentType) {
        super(transportHeaders, transportAdditionalData, event.getVariables());
        this.event = event;
        SubFlowResponse payload = this.handlePayload((TypedValue<Object>)event.getMessage().getPayload(), contentType);
        this.content = payload.getBody();
        this.soapHeaders = Collections.unmodifiableMap(payload.getHeaders());
        this.attachments = Collections.unmodifiableMap(payload.getAttachments());
        this.contentType = contentType;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public Map<String, String> getSoapHeaders() {
        return this.soapHeaders;
    }

    @Override
    public Map<String, SoapAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getContentType() {
        return this.contentType.toString();
    }

    private SubFlowResponse handlePayload(TypedValue<Object> payload, MediaType mediaType) {
        Object value = payload.getValue();
        if (value instanceof Map) {
            return SubFlowResponse.create((Map)Cast.cast(value), mediaType.getCharset().orElse(Charset.defaultCharset()));
        }
        if (value instanceof CursorStreamProvider) {
            return SubFlowResponse.createFromBody((InputStream)((CursorStreamProvider)value).openCursor());
        }
        if (value instanceof InputStream) {
            return SubFlowResponse.createFromBody((InputStream)value);
        }
        throw new IllegalArgumentException("Invalid payload detected");
    }
}

