/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.xml.stax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javanet.staxutils.DummyLocator;
import javanet.staxutils.StAXReaderToContentHandler;
import javanet.staxutils.helpers.XMLFilterImplEx;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStreamReaderToContentHandler
implements StAXReaderToContentHandler {
    private final XMLStreamReader staxStreamReader;
    private XMLFilterImplEx filter;
    public static final Pattern PREFIX_PATTERN = Pattern.compile("^.+:+(?!$)");

    public XMLStreamReaderToContentHandler(XMLStreamReader staxCore, XMLFilterImplEx filter) {
        this.staxStreamReader = staxCore;
        this.filter = filter;
    }

    public void bridge() throws XMLStreamException {
        try {
            int depth = 0;
            this.handleStartDocument();
            int event = this.staxStreamReader.getEventType();
            if (event == 7) {
                event = this.staxStreamReader.next();
                while (event != 1) {
                    switch (event) {
                        case 5: {
                            this.handleComment();
                            break;
                        }
                        case 3: {
                            this.handlePI();
                        }
                    }
                    event = this.staxStreamReader.next();
                }
            }
            if (event != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but" + event);
            }
            do {
                switch (event) {
                    case 1: {
                        ++depth;
                        this.handleStartElement();
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        --depth;
                        break;
                    }
                    case 4: {
                        this.handleCharacters();
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI();
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + event);
                    }
                }
                event = this.staxStreamReader.next();
            } while (depth != 0 || (event = this.getNextStartElement(this.staxStreamReader, event)) != 8);
            this.handleEndDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private int getNextStartElement(XMLStreamReader staxStreamReader, int event) throws XMLStreamException {
        switch (event) {
            case 1: 
            case 8: {
                return event;
            }
            case 5: {
                this.handleComment();
                break;
            }
            case 3: {
                this.handlePI();
            }
        }
        event = staxStreamReader.next();
        return this.getNextStartElement(staxStreamReader, event);
    }

    protected void handleEndDocument() throws SAXException {
        this.filter.endDocument();
    }

    protected void handleStartDocument() throws SAXException {
        final Location location = this.staxStreamReader.getLocation();
        if (location != null) {
            this.filter.setDocumentLocator(new Locator(){

                @Override
                public int getColumnNumber() {
                    return location.getColumnNumber();
                }

                @Override
                public int getLineNumber() {
                    return location.getLineNumber();
                }

                @Override
                public String getPublicId() {
                    return location.getPublicId();
                }

                @Override
                public String getSystemId() {
                    return location.getSystemId();
                }
            });
        } else {
            this.filter.setDocumentLocator((Locator)new DummyLocator());
        }
        this.filter.startDocument();
    }

    protected void handlePI() throws XMLStreamException {
        try {
            this.filter.processingInstruction(this.staxStreamReader.getPITarget(), this.staxStreamReader.getPIData());
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    protected void handleCharacters() throws XMLStreamException {
        char[] chars = this.staxStreamReader.getText().toCharArray();
        try {
            this.filter.characters(chars, 0, chars.length);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    protected void handleEndElement() throws XMLStreamException {
        QName qName = this.staxStreamReader.getName();
        try {
            String prefix = qName.getPrefix();
            String rawname = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ':' + qName.getLocalPart();
            this.filter.endElement(qName.getNamespaceURI(), qName.getLocalPart(), rawname);
            int nsCount = this.staxStreamReader.getNamespaceCount();
            for (int i = nsCount - 1; i >= 0; --i) {
                String nsprefix = this.staxStreamReader.getNamespacePrefix(i);
                if (nsprefix == null) {
                    nsprefix = "";
                }
                this.filter.endPrefixMapping(nsprefix);
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    protected void handleStartElement() throws XMLStreamException {
        try {
            int nsCount = this.staxStreamReader.getNamespaceCount();
            for (int i = 0; i < nsCount; ++i) {
                String prefix;
                String uri = this.staxStreamReader.getNamespaceURI(i);
                if (uri == null) {
                    uri = "";
                }
                if ((prefix = this.staxStreamReader.getNamespacePrefix(i)) == null) {
                    prefix = "";
                }
                this.filter.startPrefixMapping(prefix, uri);
            }
            QName qName = this.staxStreamReader.getName();
            String prefix = qName.getPrefix();
            String rawname = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ':' + qName.getLocalPart();
            Attributes attrs = this.getAttributes();
            this.filter.startElement(qName.getNamespaceURI(), qName.getLocalPart(), rawname, attrs);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    protected Attributes getAttributes() throws SAXException {
        String uri;
        int i;
        AttributesImpl attrs = new AttributesImpl();
        int eventType = this.staxStreamReader.getEventType();
        if (eventType != 10 && eventType != 1) {
            throw new InternalError("getAttributes() attempting to process: " + eventType);
        }
        if (this.filter.getNamespacePrefixes()) {
            for (i = 0; i < this.staxStreamReader.getNamespaceCount(); ++i) {
                String prefix;
                uri = this.staxStreamReader.getNamespaceURI(i);
                if (uri == null) {
                    uri = "";
                }
                if ((prefix = this.staxStreamReader.getNamespacePrefix(i)) == null) {
                    prefix = "";
                }
                String qName = "xmlns";
                if (prefix.length() == 0) {
                    prefix = qName;
                } else {
                    qName = qName + ':' + prefix;
                }
                attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, qName, "CDATA", uri);
            }
        }
        for (i = 0; i < this.staxStreamReader.getAttributeCount(); ++i) {
            uri = this.staxStreamReader.getAttributeNamespace(i);
            if (uri == null) {
                uri = "";
            }
            String localName = this.staxStreamReader.getAttributeLocalName(i);
            String prefix = this.staxStreamReader.getAttributePrefix(i);
            String qName = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
            String type = this.staxStreamReader.getAttributeType(i);
            String value = this.staxStreamReader.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri) && "type".equals(localName) && !XMLStreamReaderToContentHandler.hasPrefix(value) && StringUtils.isNotBlank((CharSequence)this.staxStreamReader.getPrefix())) {
                value = this.staxStreamReader.getPrefix() + ":" + value;
            }
            if (!prefix.isEmpty() && !uri.isEmpty()) {
                this.filter.startPrefixMapping(prefix, uri);
            }
            attrs.addAttribute(uri, localName, qName, type, value);
        }
        return attrs;
    }

    private static boolean hasPrefix(String value) {
        Matcher prefixMatcher = PREFIX_PATTERN.matcher(value);
        return prefixMatcher.find();
    }

    protected void handleNamespace() {
    }

    protected void handleAttribute() {
    }

    protected void handleDTD() {
    }

    protected void handleComment() throws XMLStreamException {
        char[] chars = this.staxStreamReader.getText().toCharArray();
        try {
            this.filter.comment(chars, 0, chars.length);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    protected void handleEntityReference() {
    }

    protected void handleSpace() {
    }

    protected void handleNotationDecl() {
    }

    protected void handleEntityDecl() {
    }

    protected void handleCDATA() throws XMLStreamException {
        char[] chars = this.staxStreamReader.getText().toCharArray();
        try {
            this.filter.startCDATA();
            this.filter.characters(chars, 0, chars.length);
            this.filter.endCDATA();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }
}

