/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import com.ctc.wstx.sw.BaseNsStreamWriter;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.stax.XMLStreamWriterCallback;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.server.interceptor.CtrlToNCRInputStream;
import org.mule.soapkit.soap.server.interceptor.NCRToControlCharHandler;
import org.mule.soapkit.soap.util.XmlTransformationUtils;

public class OutputPayloadInterceptor
extends AbstractOutDatabindingInterceptor {
    public static final String MULE_SOAPKIT_ALLOW_CTRL_CHARS = "mule.soapkit.allowControlCharacters";

    public OutputPayloadInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo bop;
        MessageContentsList originalList = MessageContentsList.getContentsList((Message)message);
        if (originalList == null || originalList.size() == 0) {
            return;
        }
        List clonedList = (List)originalList.clone();
        originalList.clear();
        for (Object object : clonedList) {
            if (object instanceof SoapResponse) {
                try {
                    SoapResponse response = (SoapResponse)object;
                    InputStream payload = response.getContent();
                    InputStream inputStream = OutputPayloadInterceptor.allowControlCharacters() ? new CtrlToNCRInputStream(payload) : payload;
                    XMLStreamReader streamReader = XmlTransformationUtils.inputStreamToXmlStreamReader(inputStream, MediaType.parse((String)response.getContentType()));
                    XMLStreamWriterCallback xmlStreamWriterCallback = this.createXMLStreamWriterCallback(streamReader);
                    originalList.add((Object)xmlStreamWriterCallback);
                    continue;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
            originalList.add(object);
        }
        if (!MessageUtils.isRequestor((Message)message) && (bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class)) != null) {
            this.ensurePartIndexMatchListIndex(originalList, bop.getOutput().getMessageParts());
        }
    }

    private XMLStreamWriterCallback createXMLStreamWriterCallback(Object payload) throws TransformerException {
        final XMLStreamReader reader = (XMLStreamReader)payload;
        return new XMLStreamWriterCallback(){

            public void write(XMLStreamWriter writer) throws Fault, XMLStreamException {
                if (OutputPayloadInterceptor.allowControlCharacters()) {
                    ((BaseNsStreamWriter)writer).setProperty("com.ctc.wstx.outputInvalidCharHandler", (Object)new NCRToControlCharHandler());
                }
                StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
                writer.flush();
                reader.close();
            }
        };
    }

    private void ensurePartIndexMatchListIndex(MessageContentsList contentList, List<MessagePartInfo> parts) {
        LinkedList<MessagePartInfo> sortedParts = new LinkedList<MessagePartInfo>();
        sortedParts.addAll(parts);
        this.sortPartsByIndex(sortedParts);
        int currentIndex = 0;
        for (MessagePartInfo part : sortedParts) {
            while (part.getIndex() > currentIndex) {
                contentList.add(currentIndex++, null);
            }
            currentIndex = part.getIndex() + 1;
        }
    }

    private void sortPartsByIndex(List<MessagePartInfo> parts) {
        parts.sort((o1, o2) -> o1.getIndex() < o2.getIndex() ? -1 : (o1.getIndex() == o2.getIndex() ? 0 : 1));
    }

    private static boolean allowControlCharacters() {
        String allowControlCharactersInPayload = System.getProperty(MULE_SOAPKIT_ALLOW_CTRL_CHARS);
        if (allowControlCharactersInPayload == null) {
            return false;
        }
        return Boolean.parseBoolean(allowControlCharactersInPayload);
    }
}

