/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.legacy.ProcessorServiceHandler;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.processors.ODataServiceDispatcher;

public class OData4Handler {
    private ServiceHandler handler;
    private final ServiceMetadata serviceMetadata;
    private final OData odata;

    public OData4Handler(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
        this.handler = new ProcessorServiceHandler();
        this.handler.init(odata, serviceMetadata);
    }

    public APIKitODataResponse process(ODataRequest request) throws Exception {
        APIKitODataResponse response = new APIKitODataResponse();
        this.validateODataVersion(request, response);
        ODataServiceDispatcher dispatcher = new ODataServiceDispatcher(this.odata, this.serviceMetadata, this.handler, null);
        dispatcher.execute(request, response);
        return response;
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, (ODataLibraryException.MessageKey)ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, new String[]{maxVersion});
        }
    }

    public void register(Processor processor) {
        if (processor instanceof ServiceHandler) {
            this.handler = (ServiceHandler)processor;
            this.handler.init(this.odata, this.serviceMetadata);
        }
        if (this.handler instanceof ProcessorServiceHandler) {
            ((ProcessorServiceHandler)this.handler).register(processor);
        }
    }

    public Edm getEdm() {
        return this.serviceMetadata.getEdm();
    }

    public OData getOdata() {
        return this.odata;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }
}

