/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.handlers;

import java.io.InputStream;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.mule.extension.api.serialization.CollectionSuccessResponse;
import org.mule.extension.internal.exception.DeserializationException;
import org.mule.extension.internal.exception.SerializationException;
import org.mule.extension.internal.handlers.ResponseHandler;
import org.mule.extension.internal.serialization.queryoptions.QueryOptionModifier;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class EntityCollectionResponseHandler
extends ResponseHandler<EntityCollection, CollectionSuccessResponse> {
    public EntityCollectionResponseHandler(OData oData, ServiceMetadata serviceMetadata) {
        super(oData, serviceMetadata);
    }

    @Override
    protected EntityCollection deserialize(InputStream inboundContent, ContentType inboundContentType, EdmEntityType entityType) {
        try {
            return this.oData.createDeserializer(inboundContentType, this.serviceMetadata).entityCollection(inboundContent, entityType).getEntityCollection();
        }
        catch (DeserializerException e) {
            throw new DeserializationException("An error occurred while deserializing entity collection", e);
        }
    }

    @Override
    protected Result<InputStream, MultiMap<String, Object>> serialize(EntityCollection entityCollection, CollectionSuccessResponse flowResponse, UriInfo uriInfo, ODataRequest request, ContentType responseFormat) {
        try {
            ContentType outputFormat = this.getResponseFormat(responseFormat);
            QueryOptionModifier.build(flowResponse.getResponseParameters().orElse(null), request.getRawRequestUri(), uriInfo).apply(entityCollection);
            ResponseHandler.Serialize serialize = this.getSerializationFunctionByUriResourceType(entityCollection, this.oData.createSerializer(outputFormat), (EdmEntityType)OlingoUtils.getReturnEntityType(uriInfo).orElse(null), uriInfo, request.getRawBaseUri());
            return Result.builder().output((Object)serialize.serialize().getContent()).mediaType(MediaType.parse((String)outputFormat.toContentTypeString())).attributes(flowResponse.getFlowResponseMetadataProperties()).build();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Exception while serializing Entity Collection", e);
        }
    }

    @Override
    protected void addSuffix(UriResource uriResource, ContextURL.Builder builder) {
    }

    @Override
    protected ResponseHandler.Serialize getSerializationFunctionByUriResourceType(EntityCollection content, ODataSerializer serializer, EdmEntityType entityType, UriInfo uriInfo, String rawBaseUri) {
        return () -> {
            String format;
            FormatOption formatOption = uriInfo.getFormatOption();
            String string = format = formatOption != null ? formatOption.getFormat() : null;
            if ("xml".equalsIgnoreCase(format) || "application/xml".equalsIgnoreCase(format)) {
                for (Entity entity : content) {
                    this.addRelRecursive(entity);
                }
            }
            try {
                return serializer.entityCollection(this.serviceMetadata, entityType, (AbstractEntityCollection)content, EntityCollectionSerializerOptions.with().contextURL(this.getContextUrl(rawBaseUri, uriInfo)).count(uriInfo.getCountOption()).expand(uriInfo.getExpandOption()).select(uriInfo.getSelectOption()).build());
            }
            catch (SerializerException e) {
                throw new SerializationException("Exception while serializing Entity Collection", e);
            }
        };
    }
}

