/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.Document;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXPathExpressionEvaluator
implements ExpressionEvaluator,
Initialisable,
Disposable,
MuleContextAware {
    private Map<String, XPath> cache = new WeakHashMap<String, XPath>(8);
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                public void onNotification(MuleContextNotification notification) {
                    if (103 == notification.getAction()) {
                        try {
                            AbstractXPathExpressionEvaluator.this.namespaceManager = (NamespaceManager)AbstractXPathExpressionEvaluator.this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
                        }
                        catch (RegistrationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new InitialisationException(t, (Initialisable)this);
        }
    }

    public void inject() throws Exception {
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
    }

    public Object evaluate(String expression, MuleMessage message) {
        try {
            Object payload = message.getPayload();
            if (payload instanceof String) {
                payload = message.getPayload(DataTypeFactory.create(Document.class));
            }
            XPath xpath = this.getXPath(expression, payload);
            if (this.namespaceManager != null) {
                this.addNamespaces(this.namespaceManager, xpath);
            }
            List<?> result = xpath.selectNodes(payload);
            if ((result = this.extractResultsFromNodes(result)).size() == 1) {
                return result.get(0);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(expression), (Throwable)e);
        }
    }

    protected void addNamespaces(NamespaceManager manager, XPath xpath) {
        for (Map.Entry entry : manager.getNamespaces().entrySet()) {
            try {
                xpath.addNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (JaxenException e) {
                throw new ExpressionRuntimeException(XmlMessages.failedToRegisterNamespace(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    public final void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected XPath getXPath(String expression, Object object) throws JaxenException {
        XPath xpath = this.cache.get(expression + this.getClass().getName());
        if (xpath == null) {
            xpath = this.createXPath(expression, object);
            this.cache.put(expression + this.getClass().getName(), xpath);
        }
        return xpath;
    }

    protected abstract XPath createXPath(String var1, Object var2) throws JaxenException;

    protected List<?> extractResultsFromNodes(List<?> results) {
        if (results == null) {
            return null;
        }
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (Object o : results) {
            newResults.add(this.extractResultFromNode(o));
        }
        return newResults;
    }

    public void dispose() {
        this.cache.clear();
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected abstract Object extractResultFromNode(Object var1);
}

