/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.Document;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.util.expression.ExpressionEvaluator;

public abstract class AbstractXPathExpressionEvaluator
implements ExpressionEvaluator,
Disposable {
    private Map cache = new WeakHashMap(8);

    public Object evaluate(String expression, Object message) {
        try {
            MuleMessage muleMessage;
            if (message instanceof MuleMessage && ((message = (muleMessage = (MuleMessage)message).getPayload()) instanceof String || message instanceof InputStream)) {
                message = muleMessage.getPayload(Document.class);
            }
            XPath xpath = this.getXPath(expression, message);
            List result = xpath.selectNodes(message);
            if ((result = this.extractResultsFromNodes(result)).size() == 1) {
                return result.get(0);
            }
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(expression), (Throwable)e);
        }
    }

    public final void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected XPath getXPath(String expression, Object object) throws JaxenException {
        XPath xpath = (XPath)this.cache.get(expression + this.getClass().getName());
        if (xpath == null) {
            xpath = this.createXPath(expression, object);
            this.cache.put(expression + this.getClass().getName(), xpath);
        }
        return xpath;
    }

    protected abstract XPath createXPath(String var1, Object var2) throws JaxenException;

    protected List extractResultsFromNodes(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (Object o : results) {
            newResults.add(this.extractResultFromNode(o));
        }
        return newResults;
    }

    public void dispose() {
        this.cache.clear();
    }

    protected abstract Object extractResultFromNode(Object var1);
}

