/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters.xml;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.util.StringMessageUtils;

public class JXPathFilter
implements UMOFilter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String pattern;
    private String expectedValue;
    private Map namespaces = null;
    private Map contextProperties = null;
    private AbstractFactory factory;
    private boolean lenient = true;

    public JXPathFilter() {
    }

    public JXPathFilter(String pattern) {
        this.pattern = pattern;
    }

    public JXPathFilter(String pattern, String expectedValue) {
        this.pattern = pattern;
        this.expectedValue = expectedValue;
    }

    public boolean accept(UMOMessage obj) {
        if (obj.getPayload() instanceof byte[]) {
            try {
                return this.accept(obj.getPayloadAsString());
            }
            catch (Exception e) {
                this.logger.warn((Object)("JxPath filter rejected message because it could not convert from byte[] to String" + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        return this.accept(obj.getPayload());
    }

    private boolean accept(Object obj) {
        if (obj == null) {
            this.logger.warn((Object)"Applying JXPathFilter to null object.");
            return false;
        }
        if (this.pattern == null) {
            this.logger.warn((Object)"Expression for JXPathFilter is not set.");
            return false;
        }
        if (this.expectedValue == null) {
            if (this.pattern.endsWith("= null") || this.pattern.endsWith("=null")) {
                this.expectedValue = "null";
                this.pattern = this.pattern.substring(0, this.pattern.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Expected value for JXPathFilter is not set, using 'true' by default");
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        Object xpathResult = null;
        boolean accept = false;
        if (obj instanceof Document) {
            if (this.namespaces == null) {
                xpathResult = ((Document)obj).valueOf(this.pattern);
            } else {
                XPath xpath = DocumentHelper.createXPath((String)this.pattern);
                xpath.setNamespaceURIs(this.namespaces);
                xpathResult = xpath.valueOf(obj);
            }
        } else {
            if (obj instanceof String) {
                try {
                    return this.accept(DocumentHelper.parseText((String)((String)obj)));
                }
                catch (DocumentException e) {
                    this.logger.warn((Object)("JXPathFilter unable to parse XML document: " + e.getMessage()), (Throwable)e);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("XML = " + StringMessageUtils.truncate((String)((String)obj), (int)200, (boolean)false)));
                    }
                    return false;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Passing object of type " + obj.getClass().getName() + " to JXPathContext"));
            }
            JXPathContext context = JXPathContext.newContext((Object)obj);
            this.initialise(context);
            xpathResult = context.getValue(this.pattern);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JXPathFilter Expression result = '" + xpathResult + "' -  Expected value = '" + this.expectedValue + "'"));
        }
        if (xpathResult != null) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if (this.expectedValue.equals("null")) {
            accept = true;
        } else {
            this.logger.warn((Object)("JXPathFilter expression evaluates to null: " + this.pattern));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JXPathFilter accept object  : " + accept));
        }
        return accept;
    }

    protected void initialise(JXPathContext context) {
        Map.Entry entry;
        Iterator iterator;
        if (this.namespaces != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing JXPathContext with namespaces: " + this.namespaces));
            }
            iterator = this.namespaces.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                context.registerNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (this.contextProperties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing JXPathContext with properties: " + this.contextProperties));
            }
            iterator = this.contextProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                context.setValue(entry.getKey().toString(), entry.getValue());
            }
        }
        if (this.factory != null) {
            context.setFactory(this.factory);
        }
        context.setLenient(this.lenient);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public String getValue() {
        return this.getExpectedValue();
    }

    public void setValue(String value) {
        this.setExpectedValue(value);
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    public AbstractFactory getFactory() {
        return this.factory;
    }

    public void setFactory(AbstractFactory factory) {
        this.factory = factory;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }
}

