/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import com.thoughtworks.xstream.XStream;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.transformers.xml.XStreamFactory;
import org.mule.umo.transformer.TransformerException;

public abstract class AbstractXStreamTransformer
extends AbstractEventAwareTransformer {
    private final AtomicReference xstream = new AtomicReference();
    private volatile String driverClassName = "com.thoughtworks.xstream.io.xml.XppDriver";
    private volatile Map aliases = null;
    private volatile List converters = null;

    public final XStream getXStream() throws TransformerException {
        XStream instance = (XStream)this.xstream.get();
        if (instance == null) {
            try {
                instance = new XStreamFactory(this.driverClassName, this.aliases, this.converters).getInstance();
                if (!this.xstream.compareAndSet(null, (Object)instance)) {
                    instance = (XStream)this.xstream.get();
                }
            }
            catch (Exception e) {
                throw new TransformerException(Message.createStaticMessage((String)"Unable to initialize XStream"), (Throwable)e);
            }
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXStreamTransformer clone = (AbstractXStreamTransformer)((Object)super.clone());
        clone.setDriverClassName(this.driverClassName);
        if (this.aliases != null) {
            clone.setAliases(new HashMap(this.aliases));
        }
        if (this.converters != null) {
            clone.setConverters(new ArrayList(this.converters));
        }
        return clone;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        this.xstream.set(null);
    }

    public Map getAliases() {
        return this.aliases;
    }

    public void setAliases(Map aliases) {
        this.aliases = aliases;
        this.xstream.set(null);
    }

    public List getConverters() {
        return this.converters;
    }

    public void setConverters(List converters) {
        this.converters = converters;
        this.xstream.set(null);
    }

    protected boolean requiresCurrentEvent() {
        return false;
    }
}

