/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.FilteringXmlMessageSplitter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public class RoundRobinXmlSplitter
extends FilteringXmlMessageSplitter {
    protected boolean enableEndpointFiltering = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        List parts;
        UMOMessage result;
        String correlationId;
        block13: {
            correlationId = (String)this.propertyExtractor.getProperty("MULE_CORRELATION_ID", message);
            this.initialise(message);
            result = null;
            parts = (List)nodes.get();
            if (parts != null) break block13;
            this.logger.error((Object)("There are no parts for current message. No events were routed: " + message));
            UMOMessage uMOMessage = null;
            Object var16_9 = null;
            nodes.set(null);
            properties.set(null);
            return uMOMessage;
        }
        try {
            int correlationSequence = 1;
            int epCounter = 0;
            Iterator iterator = parts.iterator();
            while (iterator.hasNext()) {
                Document part = (Document)iterator.next();
                if (epCounter == this.endpoints.size()) {
                    epCounter = 0;
                }
                Map theProperties = (Map)properties.get();
                message = new MuleMessage((Object)part, new HashMap(theProperties));
                UMOEndpoint endpoint = this.enableEndpointFiltering ? this.getEndpointForMessage(message) : (UMOEndpoint)this.getEndpoints().get(epCounter);
                if (endpoint == null) {
                    this.logger.error((Object)("There was no matching endpoint for message part: " + part.asXML()));
                } else {
                    try {
                        if (this.enableCorrelation != 2) {
                            boolean correlationSet;
                            boolean bl = correlationSet = message.getCorrelationId() != null;
                            if (!correlationSet && this.enableCorrelation == 0) {
                                message.setCorrelationId(correlationId);
                            }
                            int groupSize = message.getCorrelationGroupSize();
                            message.setCorrelationGroupSize(groupSize);
                            message.setCorrelationSequence(correlationSequence++);
                        }
                        if (synchronous) {
                            result = this.send(session, message, endpoint);
                        } else {
                            this.dispatch(session, message, endpoint);
                        }
                    }
                    catch (UMOException e) {
                        throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
                    }
                }
                ++epCounter;
            }
            UMOMessage uMOMessage = result;
            Object var16_10 = null;
            nodes.set(null);
            properties.set(null);
            return uMOMessage;
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            nodes.set(null);
            properties.set(null);
            throw throwable;
        }
    }

    protected UMOEndpoint getEndpointForMessage(UMOMessage message) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            UMOEndpoint endpoint = (UMOEndpoint)this.endpoints.get(i);
            try {
                if (endpoint.getFilter() == null || endpoint.getFilter().accept(message)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Endpoint filter matched for node " + i + ". Routing message over: " + endpoint.getEndpointURI().toString()));
                    }
                    return endpoint;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Endpoint filter did not match");
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create message for node at position " + i), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (endpoint.getFilter() != null && !this.enableEndpointFiltering) {
            throw new IllegalStateException("Endpoints on the RoundRobin splitter router cannot have filters associated with them");
        }
        super.addEndpoint(endpoint);
    }

    public boolean isEnableEndpointFiltering() {
        return this.enableEndpointFiltering;
    }

    public void setEnableEndpointFiltering(boolean enableEndpointFiltering) {
        this.enableEndpointFiltering = enableEndpointFiltering;
    }
}

