/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.mule.module.ws.security.AbstractSecurityStrategy;
import org.mule.module.ws.security.PasswordType;
import org.mule.module.ws.security.SecurityStrategy;
import org.mule.util.StringUtils;

public class WssUsernameTokenSecurityStrategy
extends AbstractSecurityStrategy
implements SecurityStrategy {
    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    @Override
    public void apply(Map<String, Object> configProperties) {
        this.appendAction(configProperties, "UsernameToken");
        configProperties.put("user", this.username);
        if (this.passwordType == PasswordType.TEXT) {
            configProperties.put("passwordType", "PasswordText");
        } else if (this.passwordType == PasswordType.DIGEST) {
            configProperties.put("passwordType", "PasswordDigest");
        }
        ArrayList<String> additionalElements = new ArrayList<String>(2);
        if (this.addNonce) {
            additionalElements.add("Nonce");
        }
        if (this.addCreated) {
            additionalElements.add("Created");
        }
        if (!additionalElements.isEmpty()) {
            configProperties.put("addUTElements", StringUtils.join(additionalElements, (String)" "));
        }
        configProperties.put("passwordCallbackRef", new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
                if (pc.getIdentifier().equals(WssUsernameTokenSecurityStrategy.this.username)) {
                    pc.setPassword(WssUsernameTokenSecurityStrategy.this.password);
                }
            }
        });
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PasswordType getPasswordType() {
        return this.passwordType;
    }

    public void setPasswordType(PasswordType passwordType) {
        this.passwordType = passwordType;
    }

    public boolean isAddNonce() {
        return this.addNonce;
    }

    public void setAddNonce(boolean addNonce) {
        this.addNonce = addNonce;
    }

    public boolean isAddCreated() {
        return this.addCreated;
    }

    public void setAddCreated(boolean addCreated) {
        this.addCreated = addCreated;
    }
}

