/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.module.ws.security.WSSecurity;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public class WSConsumerConfig
implements MuleContextAware {
    private MuleContext muleContext;
    private String name;
    private String wsdlLocation;
    private String service;
    private String port;
    private String serviceAddress;
    private Connector connector;
    private WSSecurity security;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public OutboundEndpoint createOutboundEndpoint() throws MuleException {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.serviceAddress), (String)"No serviceAddress provided in WS consumer config");
        EndpointBuilder builder = this.muleContext.getEndpointFactory().getEndpointBuilder(this.serviceAddress);
        if (this.connector != null) {
            String protocol = new MuleEndpointURI(this.serviceAddress, this.muleContext).getScheme();
            if (!this.connector.supportsProtocol(protocol)) {
                throw new IllegalStateException(String.format("Connector %s does not support protocol: %s", this.connector.getName(), protocol));
            }
            builder.setConnector(this.connector);
        }
        return this.muleContext.getEndpointFactory().getOutboundEndpoint(builder);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public WSSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WSSecurity security) {
        this.security = security;
    }
}

