/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;

public class OutputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    private final MuleContext muleContext;

    public OutputSoapHeadersInterceptor(MuleContext muleContext) {
        super("pre-protocol");
        this.muleContext = muleContext;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"mule.event");
        if (event == null) {
            return;
        }
        for (Header header : message.getHeaders()) {
            if (!(header instanceof SoapHeader)) continue;
            Transformer transformer = null;
            try {
                DataType sourceType = DataTypeFactory.createFromObject((Object)header.getObject());
                transformer = this.muleContext.getRegistry().lookupTransformer(sourceType, DataType.STRING_DATA_TYPE);
                String key = "soap." + header.getName().getLocalPart();
                String value = (String)transformer.transform(header.getObject());
                event.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
            }
            catch (TransformerException e) {
                throw new Fault((Throwable)new TransformerMessagingException(CoreMessages.createStaticMessage((String)"Cannot parse content of SOAP header %s in the response", (Object[])new Object[]{header.getName().getLocalPart()}), event, transformer, e.getCause()));
            }
        }
    }
}

