/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.construct.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.Transformer;
import org.mule.construct.builder.AbstractFlowConstructWithSingleOutboundEndpointBuilder;
import org.mule.module.ws.construct.WSProxy;
import org.mule.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProxyBuilder
extends AbstractFlowConstructWithSingleOutboundEndpointBuilder<WSProxyBuilder, WSProxy> {
    protected URI wsldLocation;
    protected File wsdlFile;

    protected MessageExchangePattern getInboundMessageExchangePattern() {
        return MessageExchangePattern.REQUEST_RESPONSE;
    }

    protected MessageExchangePattern getOutboundMessageExchangePattern() {
        return MessageExchangePattern.REQUEST_RESPONSE;
    }

    public WSProxyBuilder outboundTransformers(Transformer ... outboundTransformers) {
        this.outboundTransformers = Arrays.asList((MessageProcessor[])outboundTransformers);
        return this;
    }

    public WSProxyBuilder outboundResponseTransformers(Transformer ... outboundResponseTransformers) {
        this.outboundResponseTransformers = Arrays.asList((MessageProcessor[])outboundResponseTransformers);
        return this;
    }

    public WSProxyBuilder wsldLocation(URI wsldLocation) {
        this.wsldLocation = wsldLocation;
        return this;
    }

    public WSProxyBuilder wsdlFile(File wsdlFile) {
        this.wsdlFile = wsdlFile;
        return this;
    }

    protected WSProxy buildFlowConstruct(MuleContext muleContext) throws MuleException {
        if (this.wsdlFile != null) {
            return this.buildStaticWsdlContentsWSProxy(muleContext);
        }
        if (this.wsldLocation != null) {
            return this.buildStaticWsdlUriWSProxy(muleContext);
        }
        return this.buildDynamicWsdlUriWSProxy(muleContext);
    }

    private WSProxy buildDynamicWsdlUriWSProxy(MuleContext muleContext) throws MuleException {
        return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext));
    }

    private WSProxy buildStaticWsdlContentsWSProxy(MuleContext muleContext) throws MuleException {
        try {
            return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext), FileUtils.readFileToString((File)this.wsdlFile));
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe);
        }
    }

    private WSProxy buildStaticWsdlUriWSProxy(MuleContext muleContext) throws MuleException {
        return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext), this.wsldLocation);
    }
}

