/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.Locale;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.NamedObject;
import org.mule.api.config.Config;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.annotations.Extensible;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.Operations;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.capability.Xml;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.validation.api.ExceptionFactory;
import org.mule.extension.validation.internal.CommonValidationOperations;
import org.mule.extension.validation.internal.CustomValidatorOperation;
import org.mule.extension.validation.internal.DefaultExceptionFactory;
import org.mule.extension.validation.internal.ExceptionFactorySource;
import org.mule.extension.validation.internal.I18NConfig;
import org.mule.extension.validation.internal.NumberValidationOperation;
import org.mule.extension.validation.internal.ValidationMessages;
import org.mule.extension.validation.internal.ValidationStrategies;
import org.mule.util.ObjectNameHelper;

@Extension(name="validation", description="Mule Validation Extension", version="3.9")
@Operations(value={CommonValidationOperations.class, CustomValidatorOperation.class, ValidationStrategies.class, NumberValidationOperation.class})
@Xml(schemaLocation="http://www.mulesoft.org/schema/mule/validation", namespace="validation", schemaVersion="3.9")
@Extensible(alias="validator-message-processor")
public class ValidationExtension
extends AbstractAnnotatedObject
implements Config,
NamedObject,
Initialisable,
MuleContextAware {
    public static final String DEFAULT_LOCALE = Locale.getDefault().getLanguage();
    private static final String EXCEPTION_FACTORY_PARAMETER_NAME = "exceptionFactory";
    private ValidationMessages messageFactory;
    private ExceptionFactory exceptionFactory;
    private MuleContext muleContext;
    @Parameter(alias="exceptionFactory")
    @Optional
    private ExceptionFactorySource exceptionFactorySource;
    @Parameter(alias="i18n")
    @Optional
    private I18NConfig i18nConfig;

    public void initialise() throws InitialisationException {
        this.initialiseExceptionFactory();
        this.initialiseMessageFactory();
    }

    private void initialiseMessageFactory() {
        this.messageFactory = this.i18nConfig == null ? new ValidationMessages() : new ValidationMessages(this.i18nConfig.getBundlePath(), this.i18nConfig.getLocale());
    }

    private void initialiseExceptionFactory() throws InitialisationException {
        if (this.exceptionFactorySource == null) {
            this.exceptionFactory = new DefaultExceptionFactory();
        } else {
            try {
                this.exceptionFactory = (ExceptionFactory)this.exceptionFactorySource.getObject(this.muleContext);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        try {
            ObjectNameHelper objectNameHelper = new ObjectNameHelper(this.muleContext);
            this.muleContext.getRegistry().registerObject(objectNameHelper.getUniqueName(EXCEPTION_FACTORY_PARAMETER_NAME), (Object)this.exceptionFactory);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not register ExceptionFactory of class " + this.exceptionFactory.getClass().getName())), (Throwable)e);
        }
    }

    public ValidationMessages getMessageFactory() {
        return this.messageFactory;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public String getName() {
        return "Validation";
    }
}

